/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.internal;

import com.aliyun.sdk.service.oss2.credentials.AnonymousCredentialsProvider;
import com.aliyun.sdk.service.oss2.credentials.Credentials;
import com.aliyun.sdk.service.oss2.credentials.CredentialsProvider;
import com.aliyun.sdk.service.oss2.exceptions.CredentialsException;
import com.aliyun.sdk.service.oss2.exceptions.CredentialsFetchException;
import com.aliyun.sdk.service.oss2.internal.ExecuteContext;
import com.aliyun.sdk.service.oss2.internal.ExecuteMiddleware;
import com.aliyun.sdk.service.oss2.signer.NopSigner;
import com.aliyun.sdk.service.oss2.signer.Signer;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import com.aliyun.sdk.service.oss2.transport.ResponseMessage;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class SignerExecuteMiddleware
implements ExecuteMiddleware {
    private final ExecuteMiddleware nextHandler;
    private final Signer singer;
    private final CredentialsProvider provider;

    public SignerExecuteMiddleware(ExecuteMiddleware nextHandler, Signer singer, CredentialsProvider provider) {
        this.nextHandler = nextHandler;
        this.singer = Optional.ofNullable(singer).orElse(new NopSigner());
        this.provider = provider;
    }

    @Override
    public ResponseMessage execute(RequestMessage request, ExecuteContext context) throws Exception {
        return this.nextHandler.execute(this.signRequest(request, context), context);
    }

    @Override
    public CompletableFuture<ResponseMessage> executeAsync(RequestMessage request, ExecuteContext context) {
        return this.nextHandler.executeAsync(this.signRequest(request, context), context);
    }

    private RequestMessage signRequest(RequestMessage request, ExecuteContext context) {
        Credentials cred;
        if (this.provider == null || this.provider instanceof AnonymousCredentialsProvider) {
            return request;
        }
        try {
            cred = this.provider.getCredentials();
        }
        catch (Exception e) {
            throw new CredentialsFetchException(e);
        }
        if (cred == null || !cred.hasKeys()) {
            throw new CredentialsException("Credentials is null or empty.");
        }
        context.signingContext.setCredentials(cred);
        context.signingContext.setRequest(request);
        this.singer.sign(context.signingContext);
        return context.signingContext.getRequest();
    }
}

