/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.internal;

import com.aliyun.sdk.service.oss2.internal.ByteChannelObserver;
import com.aliyun.sdk.service.oss2.internal.ExecuteContext;
import com.aliyun.sdk.service.oss2.internal.ExecuteMiddleware;
import com.aliyun.sdk.service.oss2.io.ObservableInputStream;
import com.aliyun.sdk.service.oss2.io.StreamObserver;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.transport.ByteArrayBinaryData;
import com.aliyun.sdk.service.oss2.transport.ByteChannelBinaryData;
import com.aliyun.sdk.service.oss2.transport.HttpClient;
import com.aliyun.sdk.service.oss2.transport.InputStreamBinaryData;
import com.aliyun.sdk.service.oss2.transport.RequestContext;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import com.aliyun.sdk.service.oss2.transport.ResponseMessage;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public class TransportExecuteMiddleware
implements ExecuteMiddleware {
    final HttpClient httpClient;

    public TransportExecuteMiddleware(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private static RequestMessage processRequest(RequestMessage request, ExecuteContext context) {
        if (request.body() instanceof ByteChannelBinaryData) {
            throw new UnsupportedOperationException("The synchronous interface does not support ByteChannelBinaryData.");
        }
        if (context.requestBodyObserver != null && !context.requestBodyObserver.isEmpty()) {
            ObservableInputStream ois = new ObservableInputStream(request.body().toStream());
            for (StreamObserver observer : context.requestBodyObserver) {
                ois.add(observer);
            }
            Long length = request.body().getLength();
            context.observableInputStream = length != null ? ois : null;
            return request.toBuilder().body(BinaryData.fromStream(ois, length)).build();
        }
        return request;
    }

    private static ResponseMessage processResponse(ResponseMessage response) {
        BinaryData body;
        int statusCode = response.statusCode();
        if ((statusCode == 203 || statusCode / 100 != 2) && (body = response.body()) instanceof InputStreamBinaryData) {
            ResponseMessage res = response.toBuilder().body(new ByteArrayBinaryData(body.toBytes())).build();
            ((InputStreamBinaryData)body).tryClose();
            return res;
        }
        return response;
    }

    private static ResponseMessage processResponseContext(ResponseMessage response, ExecuteContext context) {
        if (context.observableInputStream != null) {
            if (response.statusCode() / 100 == 2) {
                context.observableInputStream.tryNoteFinished();
            }
            context.observableInputStream = null;
        }
        return TransportExecuteMiddleware.processResponse(response);
    }

    private static RequestContext toRequestContext(ExecuteContext context) {
        RequestContext ctx = RequestContext.empty();
        if (context.responseHeadersRead != null) {
            ctx.put(RequestContext.Key.HTTP_COMPLETION_OPTION, RequestContext.HttpCompletionOption.ResponseHeadersRead);
        }
        if (context.dataConsumerSupplier != null) {
            ctx.put(RequestContext.Key.RESPONSE_CONSUMER_SUPPLIER, context.dataConsumerSupplier);
        }
        return ctx;
    }

    private static RequestContext toRequestContextAsync(ExecuteContext context) {
        RequestContext ctx = TransportExecuteMiddleware.toRequestContext(context);
        if (context.requestBodyObserver != null && !context.requestBodyObserver.isEmpty()) {
            ArrayList<ByteChannelObserver> channels = new ArrayList<ByteChannelObserver>();
            for (StreamObserver observer : context.requestBodyObserver) {
                channels.add(new ByteChannelObserver(observer));
            }
            ctx.put(RequestContext.Key.UPLOAD_OBSERVER_CHANNEL, channels);
        }
        return ctx;
    }

    @Override
    public ResponseMessage execute(RequestMessage request, ExecuteContext context) throws Exception {
        return TransportExecuteMiddleware.processResponseContext(this.httpClient.send(TransportExecuteMiddleware.processRequest(request, context), TransportExecuteMiddleware.toRequestContext(context)), context);
    }

    @Override
    public CompletableFuture<ResponseMessage> executeAsync(RequestMessage request, ExecuteContext context) {
        return this.httpClient.sendAsync(request, TransportExecuteMiddleware.toRequestContextAsync(context)).thenApplyAsync(TransportExecuteMiddleware::processResponse);
    }
}

