/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class MultiOutputStream
extends OutputStream {
    protected final Collection<OutputStream> branches;

    public MultiOutputStream(Collection<OutputStream> branches) {
        Objects.requireNonNull(branches);
        this.branches = branches;
    }

    public MultiOutputStream(OutputStream ... branches) {
        Objects.requireNonNull(branches);
        this.branches = Arrays.asList(branches);
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream branch : this.branches) {
            branch.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (OutputStream branch : this.branches) {
            branch.write(b, 0, b.length);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (OutputStream branch : this.branches) {
            branch.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream branch : this.branches) {
            branch.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (OutputStream branch : this.branches) {
            branch.close();
        }
    }
}

