/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class MultiWriter
extends Writer {
    protected final Collection<Writer> writers;

    public MultiWriter(Collection<Writer> writers) {
        Objects.requireNonNull(writers);
        this.writers = writers;
    }

    public MultiWriter(Writer ... writers) {
        Objects.requireNonNull(writers);
        this.writers = Arrays.asList(writers);
    }

    @Override
    public void write(int c) throws IOException {
        for (Writer w : this.writers) {
            w.write(c);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (Writer w : this.writers) {
            w.write(cbuf, off, len);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        for (Writer w : this.writers) {
            w.write(str, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (Writer w : this.writers) {
            w.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (Writer w : this.writers) {
            w.close();
        }
    }
}

