/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.io;

import com.aliyun.sdk.service.oss2.io.StreamObserver;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ObservableInputStream
extends FilterInputStream {
    private boolean noteFinishedDone;
    private final List<StreamObserver> observers;

    private ObservableInputStream(InputStream inputStream, List<StreamObserver> observers) {
        super(inputStream);
        this.observers = observers;
        this.noteFinishedDone = false;
    }

    public ObservableInputStream(InputStream inputStream) {
        this(inputStream, new ArrayList<StreamObserver>());
    }

    public ObservableInputStream(InputStream inputStream, StreamObserver ... observers) {
        this(inputStream, Arrays.asList(observers));
    }

    public void add(StreamObserver observer) {
        this.observers.add(observer);
    }

    public void remove(StreamObserver observer) {
        this.observers.remove(observer);
    }

    public void removeAllObservers() {
        this.observers.clear();
    }

    public List<StreamObserver> getObservers() {
        return new ArrayList<StreamObserver>(this.observers);
    }

    public InputStream unwrap() {
        return this.in;
    }

    public void tryNoteFinished() {
        try {
            this.noteFinished();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void noteClosed() throws IOException {
        for (StreamObserver observer : this.observers) {
            observer.closed();
        }
    }

    protected void noteDataByte(int value) throws IOException {
        for (StreamObserver observer : this.observers) {
            observer.data(value);
        }
    }

    protected void noteDataBytes(byte[] buffer, int offset, int length) throws IOException {
        for (StreamObserver observer : this.observers) {
            observer.data(buffer, offset, length);
        }
    }

    protected void noteError(IOException exception) throws IOException {
        for (StreamObserver observer : this.observers) {
            observer.error(exception);
        }
    }

    protected void noteFinished() throws IOException {
        if (!this.noteFinishedDone) {
            for (StreamObserver observer : this.observers) {
                observer.finished();
            }
        }
        this.noteFinishedDone = true;
    }

    private void notify(byte[] buffer, int offset, int result, IOException ioe) throws IOException {
        if (ioe != null) {
            this.noteError(ioe);
            throw ioe;
        }
        if (result == -1) {
            this.noteFinished();
        } else if (result > 0) {
            this.noteDataBytes(buffer, offset, result);
        }
    }

    @Override
    public int read() throws IOException {
        int result = 0;
        IOException ioe = null;
        try {
            result = this.in.read();
        }
        catch (IOException ex) {
            ioe = ex;
        }
        if (ioe != null) {
            this.noteError(ioe);
            throw ioe;
        }
        if (result == -1) {
            this.noteFinished();
        } else {
            this.noteDataByte(result);
        }
        return result;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int result = 0;
        IOException ioe = null;
        try {
            result = this.in.read(buffer, offset, length);
        }
        catch (IOException ex) {
            ioe = ex;
        }
        this.notify(buffer, offset, result, ioe);
        return result;
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        try {
            this.in.close();
        }
        catch (IOException e) {
            ioe = e;
        }
        if (ioe == null) {
            this.noteClosed();
        } else {
            this.noteError(ioe);
        }
    }
}

