/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import com.aliyun.sdk.service.oss2.models.internal.CastUtils;
import com.aliyun.sdk.service.oss2.progress.ProgressListener;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.utils.ConvertUtils;
import java.util.Map;
import java.util.Objects;

public final class AppendObjectRequest
extends RequestModel {
    private final String bucket;
    private final String key;
    private final BinaryData body;
    private final ProgressListener progressListener;
    private final Long initHashCRC64;

    private AppendObjectRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.body = builder.body;
        this.progressListener = builder.progressListener;
        this.initHashCRC64 = builder.initHashCRC64;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String serverSideEncryption() {
        String value = (String)this.headers.get("x-oss-server-side-encryption");
        return value;
    }

    public String serverSideDataEncryption() {
        String value = (String)this.headers.get("x-oss-server-side-data-encryption");
        return value;
    }

    public String serverSideEncryptionKeyId() {
        String value = (String)this.headers.get("x-oss-server-side-encryption-key-id");
        return value;
    }

    public String objectAcl() {
        String value = (String)this.headers.get("x-oss-object-acl");
        return value;
    }

    public String storageClass() {
        String value = (String)this.headers.get("x-oss-storage-class");
        return value;
    }

    public Map<String, String> metadata() {
        return CastUtils.toMetadata(this.headers);
    }

    public String cacheControl() {
        String value = (String)this.headers.get("Cache-Control");
        return value;
    }

    public String contentDisposition() {
        String value = (String)this.headers.get("Content-Disposition");
        return value;
    }

    public String contentEncoding() {
        String value = (String)this.headers.get("Content-Encoding");
        return value;
    }

    public Long contentLength() {
        String value = (String)this.headers.get("Content-Length");
        return ConvertUtils.toLongOrNull(value);
    }

    public String contentMd5() {
        String value = (String)this.headers.get("Content-MD5");
        return value;
    }

    public String contentType() {
        String value = (String)this.headers.get("Content-Type");
        return value;
    }

    public String expires() {
        String value = (String)this.headers.get("Expires");
        return value;
    }

    public Long position() {
        String value = (String)this.parameters.get("position");
        return ConvertUtils.toLongOrNull(value);
    }

    public String tagging() {
        String value = (String)this.headers.get("x-oss-tagging");
        return value;
    }

    public Boolean forbidOverwrite() {
        String value = (String)this.headers.get("x-oss-forbid-overwrite");
        return ConvertUtils.toBoolOrNull(value);
    }

    public Integer trafficLimit() {
        String value = (String)this.headers.get("x-oss-traffic-limit");
        return ConvertUtils.toIntegerOrNull(value);
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public ProgressListener progressListener() {
        return this.progressListener;
    }

    public Long initHashCRC64() {
        return this.initHashCRC64;
    }

    public BinaryData body() {
        return this.body;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;
        private BinaryData body;
        private ProgressListener progressListener;
        private Long initHashCRC64;

        private Builder() {
        }

        private Builder(AppendObjectRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
            this.body = request.body;
            this.progressListener = request.progressListener;
            this.initHashCRC64 = request.initHashCRC64;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder serverSideEncryption(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-server-side-encryption", value);
            return this;
        }

        public Builder serverSideDataEncryption(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-server-side-data-encryption", value);
            return this;
        }

        public Builder serverSideEncryptionKeyId(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-server-side-encryption-key-id", value);
            return this;
        }

        public Builder objectAcl(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-object-acl", value);
            return this;
        }

        public Builder storageClass(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-storage-class", value);
            return this;
        }

        public Builder metadata(Map<String, String> value) {
            Objects.requireNonNull(value);
            value.forEach((k, v) -> this.headers.put("x-oss-meta-" + k, v));
            return this;
        }

        public Builder cacheControl(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Cache-Control", value);
            return this;
        }

        public Builder contentDisposition(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-Disposition", value);
            return this;
        }

        public Builder contentEncoding(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-Encoding", value);
            return this;
        }

        public Builder contentLength(Long value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-Length", value.toString());
            return this;
        }

        public Builder contentMd5(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-MD5", value);
            return this;
        }

        public Builder contentType(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-Type", value);
            return this;
        }

        public Builder expires(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Expires", value);
            return this;
        }

        public Builder position(Long value) {
            Objects.requireNonNull(value);
            this.parameters.put("position", value.toString());
            return this;
        }

        public Builder tagging(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-tagging", value);
            return this;
        }

        public Builder forbidOverwrite(Boolean value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-forbid-overwrite", value.toString());
            return this;
        }

        public Builder trafficLimit(Integer value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-traffic-limit", value.toString());
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public Builder progressListener(ProgressListener progressListener) {
            Objects.requireNonNull(progressListener);
            this.progressListener = progressListener;
            return this;
        }

        public Builder body(BinaryData value) {
            Objects.requireNonNull(value);
            this.body = value;
            return this;
        }

        public Builder initHashCRC64(long value) {
            this.initHashCRC64 = value;
            return this;
        }

        public AppendObjectRequest build() {
            return new AppendObjectRequest(this);
        }
    }
}

