/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Objects;

@JacksonXmlRootElement(localName="BucketDataRedundancyTransition")
public final class BucketDataRedundancyTransition {
    @JacksonXmlProperty(localName="Bucket")
    private String bucket;
    @JacksonXmlProperty(localName="TaskId")
    private String taskId;
    @JacksonXmlProperty(localName="Status")
    private String status;
    @JacksonXmlProperty(localName="CreateTime")
    private String createTime;
    @JacksonXmlProperty(localName="StartTime")
    private String startTime;
    @JacksonXmlProperty(localName="ProcessPercentage")
    private Integer processPercentage;
    @JacksonXmlProperty(localName="EstimatedRemainingTime")
    private Long estimatedRemainingTime;
    @JacksonXmlProperty(localName="EndTime")
    private String endTime;

    public BucketDataRedundancyTransition() {
    }

    private BucketDataRedundancyTransition(Builder builder) {
        this.bucket = builder.bucket;
        this.taskId = builder.taskId;
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.startTime = builder.startTime;
        this.processPercentage = builder.processPercentage;
        this.estimatedRemainingTime = builder.estimatedRemainingTime;
        this.endTime = builder.endTime;
    }

    public String bucket() {
        return this.bucket;
    }

    public String taskId() {
        return this.taskId;
    }

    public String status() {
        return this.status;
    }

    public String createTime() {
        return this.createTime;
    }

    public String startTime() {
        return this.startTime;
    }

    public Integer processPercentage() {
        return this.processPercentage;
    }

    public Long estimatedRemainingTime() {
        return this.estimatedRemainingTime;
    }

    public String endTime() {
        return this.endTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String bucket;
        private String taskId;
        private String status;
        private String createTime;
        private String startTime;
        private Integer processPercentage;
        private Long estimatedRemainingTime;
        private String endTime;

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder taskId(String value) {
            Objects.requireNonNull(value);
            this.taskId = value;
            return this;
        }

        public Builder status(String value) {
            Objects.requireNonNull(value);
            this.status = value;
            return this;
        }

        public Builder createTime(String value) {
            Objects.requireNonNull(value);
            this.createTime = value;
            return this;
        }

        public Builder createTime(Instant value) {
            Objects.requireNonNull(value);
            this.createTime = value.atOffset(ZoneOffset.UTC).format(new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").toFormatter());
            return this;
        }

        public Builder startTime(String value) {
            Objects.requireNonNull(value);
            this.startTime = value;
            return this;
        }

        public Builder startTime(Instant value) {
            Objects.requireNonNull(value);
            this.startTime = value.atOffset(ZoneOffset.UTC).format(new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").toFormatter());
            return this;
        }

        public Builder processPercentage(Integer value) {
            Objects.requireNonNull(value);
            this.processPercentage = value;
            return this;
        }

        public Builder estimatedRemainingTime(Long value) {
            Objects.requireNonNull(value);
            this.estimatedRemainingTime = value;
            return this;
        }

        public Builder endTime(String value) {
            Objects.requireNonNull(value);
            this.endTime = value;
            return this;
        }

        public Builder endTime(Instant value) {
            Objects.requireNonNull(value);
            this.endTime = value.atOffset(ZoneOffset.UTC).format(new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").toFormatter());
            return this;
        }

        private Builder() {
        }

        private Builder(BucketDataRedundancyTransition from) {
            this.bucket = from.bucket;
            this.taskId = from.taskId;
            this.status = from.status;
            this.createTime = from.createTime;
            this.startTime = from.startTime;
            this.processPercentage = from.processPercentage;
            this.estimatedRemainingTime = from.estimatedRemainingTime;
            this.endTime = from.endTime;
        }

        public BucketDataRedundancyTransition build() {
            return new BucketDataRedundancyTransition(this);
        }
    }
}

