/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.List;
import java.util.Objects;

@JacksonXmlRootElement(localName="CORSRule")
public final class CORSRule {
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="AllowedHeader")
    private List<String> allowedHeaders;
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="ExposeHeader")
    private List<String> exposeHeaders;
    @JacksonXmlProperty(localName="MaxAgeSeconds")
    private Long maxAgeSeconds;
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="AllowedOrigin")
    private List<String> allowedOrigins;
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="AllowedMethod")
    private List<String> allowedMethods;

    public CORSRule() {
    }

    private CORSRule(Builder builder) {
        this.allowedHeaders = builder.allowedHeaders;
        this.exposeHeaders = builder.exposeHeaders;
        this.maxAgeSeconds = builder.maxAgeSeconds;
        this.allowedOrigins = builder.allowedOrigins;
        this.allowedMethods = builder.allowedMethods;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    public List<String> exposeHeaders() {
        return this.exposeHeaders;
    }

    public Long maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public List<String> allowedMethods() {
        return this.allowedMethods;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private List<String> allowedHeaders;
        private List<String> exposeHeaders;
        private Long maxAgeSeconds;
        private List<String> allowedOrigins;
        private List<String> allowedMethods;

        private Builder() {
        }

        private Builder(CORSRule from) {
            this.allowedHeaders = from.allowedHeaders;
            this.exposeHeaders = from.exposeHeaders;
            this.maxAgeSeconds = from.maxAgeSeconds;
            this.allowedOrigins = from.allowedOrigins;
            this.allowedMethods = from.allowedMethods;
        }

        public Builder allowedHeaders(List<String> value) {
            Objects.requireNonNull(value);
            this.allowedHeaders = value;
            return this;
        }

        public Builder exposeHeaders(List<String> value) {
            Objects.requireNonNull(value);
            this.exposeHeaders = value;
            return this;
        }

        public Builder maxAgeSeconds(Long value) {
            Objects.requireNonNull(value);
            this.maxAgeSeconds = value;
            return this;
        }

        public Builder allowedOrigins(List<String> value) {
            Objects.requireNonNull(value);
            this.allowedOrigins = value;
            return this;
        }

        public Builder allowedMethods(List<String> value) {
            Objects.requireNonNull(value);
            this.allowedMethods = value;
            return this;
        }

        public CORSRule build() {
            return new CORSRule(this);
        }
    }
}

