/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.utils.Base64Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class CallbackHelper {
    private final String callbackUrl;
    private final String callbackHost;
    private final String callbackBody;
    private final String callbackBodyType;
    private final Boolean callbackSNI;
    private final Map<String, String> callbackVar;

    private CallbackHelper(Builder builder) {
        this.callbackUrl = builder.callbackUrl;
        this.callbackHost = builder.callbackHost;
        this.callbackBody = builder.callbackBody;
        this.callbackBodyType = builder.callbackBodyType;
        this.callbackSNI = builder.callbackSNI;
        this.callbackVar = builder.callbackVar;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String callbackUrl() {
        return this.callbackUrl;
    }

    public String callbackHost() {
        return this.callbackHost;
    }

    public String callbackBody() {
        return this.callbackBody;
    }

    public String callbackBodyType() {
        return this.callbackBodyType;
    }

    public Boolean callbackSNI() {
        return this.callbackSNI;
    }

    public Map<String, String> callbackVar() {
        return this.callbackVar;
    }

    public String toCallbackParameter() {
        LinkedHashMap<String, Object> callbackMap = new LinkedHashMap<String, Object>();
        if (this.callbackUrl != null) {
            callbackMap.put("callbackUrl", this.callbackUrl);
        }
        if (this.callbackHost != null) {
            callbackMap.put("callbackHost", this.callbackHost);
        }
        if (this.callbackBody != null) {
            callbackMap.put("callbackBody", this.callbackBody);
        }
        if (this.callbackBodyType != null) {
            callbackMap.put("callbackBodyType", this.callbackBodyType);
        }
        if (this.callbackSNI != null) {
            callbackMap.put("callbackSNI", this.callbackSNI);
        }
        return CallbackHelper.toJsonBase64(callbackMap);
    }

    public String toCallbackVarParameter() {
        LinkedHashMap<String, Object> callbackMap = new LinkedHashMap<String, Object>();
        if (this.callbackVar != null) {
            callbackMap.putAll(this.callbackVar);
        }
        return CallbackHelper.toJsonBase64(callbackMap);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    static String toJsonBase64(Map<String, Object> value) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String json = objectMapper.writeValueAsString(value);
            return Base64Utils.encodeToString(json.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class Builder {
        private String callbackUrl;
        private String callbackHost;
        private String callbackBody;
        private String callbackBodyType;
        private Boolean callbackSNI;
        private Map<String, String> callbackVar;

        private Builder() {
        }

        private Builder(CallbackHelper from) {
            this.callbackUrl = from.callbackUrl;
            this.callbackHost = from.callbackHost;
            this.callbackBody = from.callbackBody;
            this.callbackBodyType = from.callbackBodyType;
            this.callbackSNI = from.callbackSNI;
            this.callbackVar = from.callbackVar;
        }

        public Builder callbackUrl(String value) {
            Objects.requireNonNull(value);
            this.callbackUrl = value;
            return this;
        }

        public Builder callbackHost(String value) {
            Objects.requireNonNull(value);
            this.callbackHost = value;
            return this;
        }

        public Builder callbackBody(String value) {
            Objects.requireNonNull(value);
            this.callbackBody = value;
            return this;
        }

        public Builder callbackBodyType(CallbackBodyType value) {
            Objects.requireNonNull(value);
            this.callbackBodyType = value.toString();
            return this;
        }

        public Builder callbackSNI(boolean value) {
            this.callbackSNI = value;
            return this;
        }

        public Builder callbackVar(Map<String, String> value) {
            this.callbackVar = value;
            return this;
        }

        public CallbackHelper build() {
            return new CallbackHelper(this);
        }
    }

    public static enum CallbackBodyType {
        URL_ENCODED("application/x-www-form-urlencoded"),
        JSON("application/json");

        private final String value;

        private CallbackBodyType(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

