/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.CompleteMultipartUpload;
import com.aliyun.sdk.service.oss2.models.RequestModel;
import java.util.Objects;

public final class CompleteMultipartUploadRequest
extends RequestModel {
    private final String bucket;
    private final String key;
    private final CompleteMultipartUpload completeMultipartUpload;

    private CompleteMultipartUploadRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.completeMultipartUpload = builder.completeMultipartUpload;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String forbidOverwrite() {
        String value = (String)this.headers.get("x-oss-forbid-overwrite");
        return value;
    }

    public String completeAll() {
        String value = (String)this.headers.get("x-oss-complete-all");
        return value;
    }

    public String uploadId() {
        String value = (String)this.parameters.get("uploadId");
        return value;
    }

    public String encodingType() {
        String value = (String)this.parameters.get("encoding-type");
        return value;
    }

    public String acl() {
        String value = (String)this.headers.get("x-oss-object-acl");
        return value;
    }

    public String objectAcl() {
        String value = (String)this.headers.get("x-oss-object-acl");
        return value;
    }

    public String callback() {
        String value = (String)this.headers.get("x-oss-callback");
        return value;
    }

    public String callbackVar() {
        String value = (String)this.headers.get("x-oss-callback-var");
        return value;
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public CompleteMultipartUpload completeMultipartUpload() {
        return this.completeMultipartUpload;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;
        private CompleteMultipartUpload completeMultipartUpload;

        private Builder() {
        }

        private Builder(CompleteMultipartUploadRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
            this.completeMultipartUpload = request.completeMultipartUpload;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder forbidOverwrite(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-forbid-overwrite", value);
            return this;
        }

        public Builder completeAll(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-complete-all", value);
            return this;
        }

        public Builder uploadId(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("uploadId", value);
            return this;
        }

        public Builder encodingType(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("encoding-type", value);
            return this;
        }

        public Builder completeMultipartUpload(CompleteMultipartUpload value) {
            Objects.requireNonNull(value);
            this.completeMultipartUpload = value;
            return this;
        }

        public Builder acl(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-object-acl", value);
            return this;
        }

        public Builder objectAcl(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-object-acl", value);
            return this;
        }

        public Builder callback(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-callback", value);
            return this;
        }

        public Builder callbackVar(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-callback-var", value);
            return this;
        }

        public Builder forbidOverwrite(Boolean value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-forbid-overwrite", value.toString());
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public CompleteMultipartUploadRequest build() {
            return new CompleteMultipartUploadRequest(this);
        }
    }
}

