/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.DataRedundancyType;
import com.aliyun.sdk.service.oss2.models.RequestModel;
import java.util.Objects;

public final class CreateBucketDataRedundancyTransitionRequest
extends RequestModel {
    private final String bucket;

    private CreateBucketDataRedundancyTransitionRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
    }

    public String bucket() {
        return this.bucket;
    }

    public String targetRedundancyType() {
        String value = (String)this.parameters.get("x-oss-target-redundancy-type");
        return value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder targetRedundancyType(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("x-oss-target-redundancy-type", value);
            return this;
        }

        public Builder targetRedundancyType(DataRedundancyType value) {
            Objects.requireNonNull(value);
            this.parameters.put("x-oss-target-redundancy-type", value.toString());
            return this;
        }

        public CreateBucketDataRedundancyTransitionRequest build() {
            return new CreateBucketDataRedundancyTransitionRequest(this);
        }

        private Builder() {
        }

        private Builder(CreateBucketDataRedundancyTransitionRequest request) {
            super(request);
            this.bucket = request.bucket;
        }
    }
}

