/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.Delete;
import com.aliyun.sdk.service.oss2.models.DeleteObject;
import com.aliyun.sdk.service.oss2.models.RequestModel;
import java.util.List;
import java.util.Objects;

public final class DeleteMultipleObjectsRequest
extends RequestModel {
    private final String bucket;
    private final Boolean quiet;
    private final List<DeleteObject> deleteObjects;
    private final Delete delete;

    private DeleteMultipleObjectsRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.deleteObjects = builder.deleteObjects;
        this.quiet = builder.quiet;
        this.delete = builder.delete;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String encodingType() {
        String value = (String)this.parameters.get("encoding-type");
        return value;
    }

    @Deprecated
    public List<DeleteObject> deleteObjects() {
        return this.deleteObjects;
    }

    @Deprecated
    public Boolean quiet() {
        return this.quiet;
    }

    public Delete delete() {
        return this.delete;
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private Boolean quiet;
        private List<DeleteObject> deleteObjects;
        private Delete delete;

        private Builder() {
        }

        private Builder(DeleteMultipleObjectsRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.quiet = request.quiet;
            this.deleteObjects = request.deleteObjects;
            this.delete = request.delete;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder encodingType(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("encoding-type", value);
            return this;
        }

        @Deprecated
        public Builder deleteObjects(List<DeleteObject> value) {
            Objects.requireNonNull(value);
            this.deleteObjects = value;
            return this;
        }

        @Deprecated
        public Builder quiet(boolean value) {
            this.quiet = value;
            return this;
        }

        public Builder delete(Delete value) {
            this.delete = value;
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public DeleteMultipleObjectsRequest build() {
            return new DeleteMultipleObjectsRequest(this);
        }
    }
}

