/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import com.aliyun.sdk.service.oss2.transport.BinaryDataConsumerSupplier;
import com.aliyun.sdk.service.oss2.utils.ConvertUtils;
import java.util.Objects;

public final class GetObjectRequest
extends RequestModel {
    private final String bucket;
    private final String key;
    private final BinaryDataConsumerSupplier dataConsumerSupplier;

    private GetObjectRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.dataConsumerSupplier = builder.dataConsumerSupplier;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String range() {
        String value = (String)this.headers.get("Range");
        return value;
    }

    public String ifModifiedSince() {
        String value = (String)this.headers.get("If-Modified-Since");
        return value;
    }

    public String ifUnmodifiedSince() {
        String value = (String)this.headers.get("If-Unmodified-Since");
        return value;
    }

    public String ifMatch() {
        String value = (String)this.headers.get("If-Match");
        return value;
    }

    public String ifNoneMatch() {
        String value = (String)this.headers.get("If-None-Match");
        return value;
    }

    public String acceptEncoding() {
        String value = (String)this.headers.get("Accept-Encoding");
        return value;
    }

    public String responseContentType() {
        String value = (String)this.parameters.get("response-content-type");
        return value;
    }

    public String responseContentLanguage() {
        String value = (String)this.parameters.get("response-content-language");
        return value;
    }

    public String responseExpires() {
        String value = (String)this.parameters.get("response-expires");
        return value;
    }

    public String responseCacheControl() {
        String value = (String)this.parameters.get("response-cache-control");
        return value;
    }

    public String responseContentDisposition() {
        String value = (String)this.parameters.get("response-content-disposition");
        return value;
    }

    public String responseContentEncoding() {
        String value = (String)this.parameters.get("response-content-encoding");
        return value;
    }

    public String versionId() {
        String value = (String)this.parameters.get("versionId");
        return value;
    }

    public Integer trafficLimit() {
        String value = (String)this.headers.get("x-oss-traffic-limit");
        return ConvertUtils.toIntegerOrNull(value);
    }

    public String process() {
        String value = (String)this.parameters.get("x-oss-process");
        return value;
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public String rangeBehavior() {
        String value = (String)this.headers.get("x-oss-range-behavior");
        return value;
    }

    public BinaryDataConsumerSupplier dataConsumerSupplier() {
        return this.dataConsumerSupplier;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;
        private BinaryDataConsumerSupplier dataConsumerSupplier;

        private Builder() {
        }

        private Builder(GetObjectRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
            this.dataConsumerSupplier = request.dataConsumerSupplier;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder range(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Range", value);
            return this;
        }

        public Builder ifModifiedSince(String value) {
            Objects.requireNonNull(value);
            this.headers.put("If-Modified-Since", value);
            return this;
        }

        public Builder ifUnmodifiedSince(String value) {
            Objects.requireNonNull(value);
            this.headers.put("If-Unmodified-Since", value);
            return this;
        }

        public Builder ifMatch(String value) {
            Objects.requireNonNull(value);
            this.headers.put("If-Match", value);
            return this;
        }

        public Builder ifNoneMatch(String value) {
            Objects.requireNonNull(value);
            this.headers.put("If-None-Match", value);
            return this;
        }

        public Builder acceptEncoding(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Accept-Encoding", value);
            return this;
        }

        public Builder responseContentType(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("response-content-type", value);
            return this;
        }

        public Builder responseContentLanguage(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("response-content-language", value);
            return this;
        }

        public Builder responseExpires(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("response-expires", value);
            return this;
        }

        public Builder responseCacheControl(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("response-cache-control", value);
            return this;
        }

        public Builder responseContentDisposition(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("response-content-disposition", value);
            return this;
        }

        public Builder responseContentEncoding(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("response-content-encoding", value);
            return this;
        }

        public Builder versionId(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("versionId", value);
            return this;
        }

        public Builder trafficLimit(Integer value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-traffic-limit", value.toString());
            return this;
        }

        public Builder process(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("x-oss-process", value);
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public Builder rangeBehavior(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-range-behavior", value);
            return this;
        }

        public Builder dataConsumerSupplier(BinaryDataConsumerSupplier value) {
            Objects.requireNonNull(value);
            this.dataConsumerSupplier = value;
            return this;
        }

        public GetObjectRequest build() {
            return new GetObjectRequest(this);
        }
    }
}

