/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.ResultModel;
import com.aliyun.sdk.service.oss2.models.internal.CastUtils;
import com.aliyun.sdk.service.oss2.transport.Abortable;
import com.aliyun.sdk.service.oss2.utils.ConvertUtils;
import java.io.InputStream;
import java.util.Map;

public final class GetObjectResult
extends ResultModel
implements AutoCloseable {
    GetObjectResult(Builder builder) {
        super(builder);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Long contentLength() {
        String value = (String)this.headers.get("Content-Length");
        return ConvertUtils.toLongOrNull(value);
    }

    public Long taggingCount() {
        String value = (String)this.headers.get("x\u2011oss\u2011tagging\u2011count");
        return ConvertUtils.toLongOrNull(value);
    }

    public String serverSideEncryptionKeyId() {
        String value = (String)this.headers.get("x-oss-server-side-encryption-key-id");
        return value;
    }

    public Long nextAppendPosition() {
        String value = (String)this.headers.get("x-oss-next-append-position");
        return ConvertUtils.toLongOrNull(value);
    }

    public String expiration() {
        String value = (String)this.headers.get("x-oss-expiration");
        return value;
    }

    public String eTag() {
        String value = (String)this.headers.get("ETag");
        return value;
    }

    public String objectType() {
        String value = (String)this.headers.get("x-oss-object-type");
        return value;
    }

    public String processStatus() {
        String value = (String)this.headers.get("x-oss-process-status");
        return value;
    }

    public String contentMd5() {
        String value = (String)this.headers.get("Content-Md5");
        return value;
    }

    public String contentType() {
        String value = (String)this.headers.get("Content-Type");
        return value;
    }

    public Map<String, String> metadata() {
        return CastUtils.toMetadata(this.headers);
    }

    public String serverSideEncryption() {
        String value = (String)this.headers.get("x-oss-server-side-encryption");
        return value;
    }

    public String storageClass() {
        String value = (String)this.headers.get("x-oss-storage-class");
        return value;
    }

    public String hashCrc64ecma() {
        String value = (String)this.headers.get("x-oss-hash-crc64ecma");
        return value;
    }

    public String restore() {
        String value = (String)this.headers.get("x-oss-restore");
        return value;
    }

    public String lastModified() {
        String value = (String)this.headers.get("Last-Modified");
        return value;
    }

    public String contentRange() {
        String value = (String)this.headers.get("Content-Range");
        return value;
    }

    public String contentDisposition() {
        String value = (String)this.headers.get("Content-Disposition");
        return value;
    }

    public String contentEncoding() {
        String value = (String)this.headers.get("Content-Encoding");
        return value;
    }

    public String expires() {
        String value = (String)this.headers.get("Expires");
        return value;
    }

    public String versionId() {
        String value = (String)this.headers.get("x-oss-version-id");
        return value;
    }

    public String serverSideDataEncryption() {
        String value = (String)this.headers.get("x-oss-server-side-data-encryption");
        return value;
    }

    public Boolean deleteMarker() {
        String value = (String)this.headers.get("x-oss-delete-marker");
        return ConvertUtils.toBoolOrNull(value);
    }

    public String sealedTime() {
        String value = (String)this.headers.get("x-oss-sealed-time");
        return value;
    }

    public InputStream body() {
        return (InputStream)this.innerBody;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public void close() throws Exception {
        if (this.innerBody instanceof InputStream) {
            ((InputStream)this.innerBody).close();
        }
    }

    public void abort() {
        if (this.innerBody instanceof Abortable) {
            ((Abortable)this.innerBody).abort();
        }
    }

    public static class Builder
    extends ResultModel.Builder<Builder> {
        private Builder() {
        }

        private Builder(GetObjectResult result) {
            super(result);
        }

        public GetObjectResult build() {
            return new GetObjectResult(this);
        }
    }
}

