/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import java.util.Objects;

public final class HeadObjectRequest
extends RequestModel {
    private final String bucket;
    private final String key;

    private HeadObjectRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String ifModifiedSince() {
        String value = (String)this.headers.get("If-Modified-Since");
        return value;
    }

    public String ifUnmodifiedSince() {
        String value = (String)this.headers.get("If-Unmodified-Since");
        return value;
    }

    public String ifMatch() {
        String value = (String)this.headers.get("If-Match");
        return value;
    }

    public String ifNoneMatch() {
        String value = (String)this.headers.get("If-None-Match");
        return value;
    }

    public String versionId() {
        String value = (String)this.parameters.get("versionId");
        return value;
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;

        private Builder() {
        }

        private Builder(HeadObjectRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder ifModifiedSince(String value) {
            Objects.requireNonNull(value);
            this.headers.put("If-Modified-Since", value);
            return this;
        }

        public Builder ifUnmodifiedSince(String value) {
            Objects.requireNonNull(value);
            this.headers.put("If-Unmodified-Since", value);
            return this;
        }

        public Builder ifMatch(String value) {
            Objects.requireNonNull(value);
            this.headers.put("If-Match", value);
            return this;
        }

        public Builder ifNoneMatch(String value) {
            Objects.requireNonNull(value);
            this.headers.put("If-None-Match", value);
            return this;
        }

        public Builder versionId(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("versionId", value);
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public HeadObjectRequest build() {
            return new HeadObjectRequest(this);
        }
    }
}

