/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import com.aliyun.sdk.service.oss2.models.internal.CastUtils;
import com.aliyun.sdk.service.oss2.utils.ConvertUtils;
import java.util.Map;
import java.util.Objects;

public final class InitiateMultipartUploadRequest
extends RequestModel {
    private final String bucket;
    private final String key;

    private InitiateMultipartUploadRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String forbidOverwrite() {
        String value = (String)this.headers.get("x-oss-forbid-overwrite");
        return value;
    }

    public String storageClass() {
        String value = (String)this.headers.get("x-oss-storage-class");
        return value;
    }

    public String tagging() {
        String value = (String)this.headers.get("x-oss-tagging");
        return value;
    }

    public String serverSideEncryption() {
        String value = (String)this.headers.get("x-oss-server-side-encryption");
        return value;
    }

    public String serverSideDataEncryption() {
        String value = (String)this.headers.get("x-oss-server-side-data-encryption");
        return value;
    }

    public String serverSideEncryptionKeyId() {
        String value = (String)this.headers.get("x-oss-server-side-encryption-key-id");
        return value;
    }

    public String cacheControl() {
        String value = (String)this.headers.get("Cache-Control");
        return value;
    }

    public String contentDisposition() {
        String value = (String)this.headers.get("Content-Disposition");
        return value;
    }

    public String contentEncoding() {
        String value = (String)this.headers.get("Content-Encoding");
        return value;
    }

    public String expires() {
        String value = (String)this.headers.get("Expires");
        return value;
    }

    public String encodingType() {
        String value = (String)this.parameters.get("encoding-type");
        return value;
    }

    public Long contentLength() {
        String value = (String)this.headers.get("Content-Length");
        return ConvertUtils.toLongOrNull(value);
    }

    public String contentMD5() {
        String value = (String)this.headers.get("Content-MD5");
        return value;
    }

    public String contentType() {
        String value = (String)this.headers.get("Content-Type");
        return value;
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public Map<String, String> metadata() {
        return CastUtils.toMetadata(this.headers);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;

        private Builder() {
        }

        private Builder(InitiateMultipartUploadRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder forbidOverwrite(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-forbid-overwrite", value);
            return this;
        }

        public Builder forbidOverwrite(Boolean value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-forbid-overwrite", value.toString());
            return this;
        }

        public Builder storageClass(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-storage-class", value);
            return this;
        }

        public Builder tagging(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-tagging", value);
            return this;
        }

        public Builder serverSideEncryption(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-server-side-encryption", value);
            return this;
        }

        public Builder serverSideDataEncryption(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-server-side-data-encryption", value);
            return this;
        }

        public Builder serverSideEncryptionKeyId(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-server-side-encryption-key-id", value);
            return this;
        }

        public Builder cacheControl(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Cache-Control", value);
            return this;
        }

        public Builder contentDisposition(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-Disposition", value);
            return this;
        }

        public Builder contentEncoding(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-Encoding", value);
            return this;
        }

        public Builder expires(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Expires", value);
            return this;
        }

        public Builder encodingType(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("encoding-type", value);
            return this;
        }

        public Builder contentLength(Long value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-Length", value.toString());
            return this;
        }

        public Builder contentMD5(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-MD5", value);
            return this;
        }

        public Builder contentType(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-Type", value);
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public Builder metadata(Map<String, String> value) {
            Objects.requireNonNull(value);
            value.forEach((k, v) -> this.headers.put("x-oss-meta-" + k, v));
            return this;
        }

        public InitiateMultipartUploadRequest build() {
            return new InitiateMultipartUploadRequest(this);
        }
    }
}

