/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import com.aliyun.sdk.service.oss2.utils.ConvertUtils;
import java.util.Objects;

public final class ListBucketsRequest
extends RequestModel {
    private ListBucketsRequest(Builder builder) {
        super(builder);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String resourceGroupId() {
        String value = (String)this.headers.get("x-oss-resource-group-id");
        return value;
    }

    public String prefix() {
        String value = (String)this.parameters.get("prefix");
        return value;
    }

    public String marker() {
        String value = (String)this.parameters.get("marker");
        return value;
    }

    public Long maxKeys() {
        String value = (String)this.parameters.get("max-keys");
        return ConvertUtils.toLongOrNull(value);
    }

    public String tagKey() {
        String value = (String)this.parameters.get("tag-key");
        return value;
    }

    public String tagValue() {
        String value = (String)this.parameters.get("tag-value");
        return value;
    }

    public String tagging() {
        String value = (String)this.parameters.get("tagging");
        return value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private Builder() {
        }

        private Builder(ListBucketsRequest request) {
            super(request);
        }

        public Builder resourceGroupId(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-resource-group-id", value);
            return this;
        }

        public Builder prefix(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("prefix", value);
            return this;
        }

        public Builder marker(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("marker", value);
            return this;
        }

        public Builder maxKeys(Long value) {
            Objects.requireNonNull(value);
            this.parameters.put("max-keys", value.toString());
            return this;
        }

        public Builder tagKey(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("tag-key", value);
            return this;
        }

        public Builder tagValue(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("tag-value", value);
            return this;
        }

        public Builder tagging(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("tagging", value);
            return this;
        }

        public ListBucketsRequest build() {
            return new ListBucketsRequest(this);
        }
    }
}

