/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import com.aliyun.sdk.service.oss2.utils.ConvertUtils;
import java.util.Objects;

public final class ListMultipartUploadsRequest
extends RequestModel {
    private final String bucket;

    private ListMultipartUploadsRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String delimiter() {
        String value = (String)this.parameters.get("delimiter");
        return value;
    }

    public Long maxUploads() {
        String value = (String)this.parameters.get("max-uploads");
        return ConvertUtils.toLongOrNull(value);
    }

    public String keyMarker() {
        String value = (String)this.parameters.get("key-marker");
        return value;
    }

    public String prefix() {
        String value = (String)this.parameters.get("prefix");
        return value;
    }

    public String uploadIdMarker() {
        String value = (String)this.parameters.get("upload-id-marker");
        return value;
    }

    public String encodingType() {
        String value = (String)this.parameters.get("encoding-type");
        return value;
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;

        private Builder() {
        }

        private Builder(ListMultipartUploadsRequest request) {
            super(request);
            this.bucket = request.bucket;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder delimiter(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("delimiter", value);
            return this;
        }

        public Builder maxUploads(Long value) {
            Objects.requireNonNull(value);
            this.parameters.put("max-uploads", value.toString());
            return this;
        }

        public Builder keyMarker(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("key-marker", value);
            return this;
        }

        public Builder prefix(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("prefix", value);
            return this;
        }

        public Builder uploadIdMarker(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("upload-id-marker", value);
            return this;
        }

        public Builder encodingType(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("encoding-type", value);
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public ListMultipartUploadsRequest build() {
            return new ListMultipartUploadsRequest(this);
        }
    }
}

