/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import com.aliyun.sdk.service.oss2.utils.ConvertUtils;
import java.util.Objects;

public final class ListObjectsV2Request
extends RequestModel {
    private final String bucket;

    private ListObjectsV2Request(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String delimiter() {
        String value = (String)this.parameters.get("delimiter");
        return value;
    }

    public Long maxKeys() {
        String value = (String)this.parameters.get("max-keys");
        return ConvertUtils.toLongOrNull(value);
    }

    public String prefix() {
        String value = (String)this.parameters.get("prefix");
        return value;
    }

    public String encodingType() {
        String value = (String)this.parameters.get("encoding-type");
        return value;
    }

    public Boolean fetchOwner() {
        String value = (String)this.parameters.get("fetch-owner");
        return ConvertUtils.toBoolOrNull(value);
    }

    public String startAfter() {
        String value = (String)this.parameters.get("start-after");
        return value;
    }

    public String continuationToken() {
        String value = (String)this.parameters.get("continuation-token");
        return value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;

        private Builder() {
        }

        private Builder(ListObjectsV2Request request) {
            super(request);
            this.bucket = request.bucket;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder delimiter(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("delimiter", value);
            return this;
        }

        public Builder maxKeys(Long value) {
            Objects.requireNonNull(value);
            this.parameters.put("max-keys", value.toString());
            return this;
        }

        public Builder prefix(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("prefix", value);
            return this;
        }

        public Builder encodingType(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("encoding-type", value);
            return this;
        }

        public Builder fetchOwner(Boolean value) {
            Objects.requireNonNull(value);
            this.parameters.put("fetch-owner", value.toString());
            return this;
        }

        public Builder startAfter(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("start-after", value);
            return this;
        }

        public Builder continuationToken(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("continuation-token", value);
            return this;
        }

        public ListObjectsV2Request build() {
            return new ListObjectsV2Request(this);
        }
    }
}

