/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import com.aliyun.sdk.service.oss2.utils.ConvertUtils;
import java.util.Objects;

public final class ListPartsRequest
extends RequestModel {
    private final String bucket;
    private final String key;

    private ListPartsRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String uploadId() {
        String value = (String)this.parameters.get("uploadId");
        return value;
    }

    public Long maxParts() {
        String value = (String)this.parameters.get("max-parts");
        return ConvertUtils.toLongOrNull(value);
    }

    public Long partNumberMarker() {
        String value = (String)this.parameters.get("part-number-marker");
        return ConvertUtils.toLongOrNull(value);
    }

    public String encodingType() {
        String value = (String)this.parameters.get("encoding-type");
        return value;
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;

        private Builder() {
        }

        private Builder(ListPartsRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder uploadId(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("uploadId", value);
            return this;
        }

        public Builder maxParts(Long value) {
            Objects.requireNonNull(value);
            this.parameters.put("max-parts", value.toString());
            return this;
        }

        public Builder partNumberMarker(Long value) {
            Objects.requireNonNull(value);
            this.parameters.put("part-number-marker", value.toString());
            return this;
        }

        public Builder encodingType(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("encoding-type", value);
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public ListPartsRequest build() {
            return new ListPartsRequest(this);
        }
    }
}

