/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import java.util.Objects;

public final class OptionObjectRequest
extends RequestModel {
    private final String bucket;
    private final String key;

    private OptionObjectRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String origin() {
        String value = (String)this.headers.get("Origin");
        return value;
    }

    public String accessControlRequestMethod() {
        String value = (String)this.headers.get("Access-Control-Request-Method");
        return value;
    }

    public String accessControlRequestHeaders() {
        String value = (String)this.headers.get("Access-Control-Request-Headers");
        return value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;

        private Builder() {
        }

        private Builder(OptionObjectRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder origin(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Origin", value);
            return this;
        }

        public Builder accessControlRequestMethod(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Access-Control-Request-Method", value);
            return this;
        }

        public Builder accessControlRequestHeaders(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Access-Control-Request-Headers", value);
            return this;
        }

        public OptionObjectRequest build() {
            return new OptionObjectRequest(this);
        }
    }
}

