/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PresignResult {
    private final String url;
    private final String method;
    private final Instant expiration;
    private final Map<String, String> signedHeaders;

    private PresignResult(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.expiration = builder.expiration;
        this.signedHeaders = builder.signedHeaders;
    }

    public String url() {
        return this.url;
    }

    public String method() {
        return this.method;
    }

    public Optional<Instant> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    public Optional<Map<String, String>> signedHeaders() {
        return Optional.ofNullable(this.signedHeaders);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String method;
        private Instant expiration;
        private Map<String, String> signedHeaders;

        private Builder() {
        }

        public Builder url(String value) {
            Objects.requireNonNull(value);
            this.url = value;
            return this;
        }

        public Builder method(String value) {
            Objects.requireNonNull(value);
            this.method = value;
            return this;
        }

        public Builder expiration(Instant value) {
            this.expiration = value;
            return this;
        }

        public Builder signedHeaders(Map<String, String> value) {
            this.signedHeaders = value;
            return this;
        }

        public PresignResult build() {
            return new PresignResult(this);
        }
    }
}

