/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import java.util.Objects;

public final class ProcessObjectRequest
extends RequestModel {
    private final String bucket;
    private final String key;
    private final String process;

    private ProcessObjectRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.process = builder.process;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String process() {
        return this.process;
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;
        private String process;

        private Builder() {
        }

        private Builder(ProcessObjectRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
            this.process = request.process;
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder process(String value) {
            Objects.requireNonNull(value);
            this.process = value;
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public ProcessObjectRequest build() {
            return new ProcessObjectRequest(this);
        }
    }
}

