/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.ObjectACLType;
import com.aliyun.sdk.service.oss2.models.RequestModel;
import java.util.Objects;

public final class PutBucketAclRequest
extends RequestModel {
    private final String bucket;

    private PutBucketAclRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
    }

    public String bucket() {
        return this.bucket;
    }

    public String acl() {
        String value = (String)this.headers.get("x-oss-acl");
        return value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder acl(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-acl", value);
            return this;
        }

        public Builder acl(ObjectACLType value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-acl", value.toString());
            return this;
        }

        public PutBucketAclRequest build() {
            return new PutBucketAclRequest(this);
        }

        private Builder() {
        }

        private Builder(PutBucketAclRequest request) {
            super(request);
            this.bucket = request.bucket;
        }
    }
}

