/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.CreateBucketConfiguration;
import com.aliyun.sdk.service.oss2.models.RequestModel;
import java.util.Objects;

public final class PutBucketRequest
extends RequestModel {
    private final String bucket;
    private final CreateBucketConfiguration createBucketConfiguration;

    private PutBucketRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.createBucketConfiguration = builder.createBucketConfiguration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String acl() {
        String value = (String)this.headers.get("x-oss-acl");
        return value;
    }

    public String resourceGroupId() {
        String value = (String)this.headers.get("x-oss-resource-group-id");
        return value;
    }

    public String bucketTagging() {
        String value = (String)this.headers.get("x-oss-bucket-tagging");
        return value;
    }

    public CreateBucketConfiguration createBucketConfiguration() {
        return this.createBucketConfiguration;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private CreateBucketConfiguration createBucketConfiguration;

        private Builder() {
        }

        private Builder(PutBucketRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.createBucketConfiguration = request.createBucketConfiguration;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder acl(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-acl", value);
            return this;
        }

        public Builder resourceGroupId(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-resource-group-id", value);
            return this;
        }

        public Builder bucketTagging(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-bucket-tagging", value);
            return this;
        }

        public Builder createBucketConfiguration(CreateBucketConfiguration value) {
            Objects.requireNonNull(value);
            this.createBucketConfiguration = value;
            return this;
        }

        public PutBucketRequest build() {
            return new PutBucketRequest(this);
        }
    }
}

