/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import java.util.Objects;

public final class PutSymlinkRequest
extends RequestModel {
    private final String bucket;
    private final String key;

    private PutSymlinkRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String symlinkTarget() {
        String value = (String)this.headers.get("x-oss-symlink-target");
        return value;
    }

    public String objectAcl() {
        String value = (String)this.headers.get("x-oss-object-acl");
        return value;
    }

    public String storageClass() {
        String value = (String)this.headers.get("x-oss-storage-class");
        return value;
    }

    public String forbidOverwrite() {
        String value = (String)this.headers.get("x-oss-forbid-overwrite");
        return value;
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;

        private Builder() {
        }

        private Builder(PutSymlinkRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder symlinkTarget(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-symlink-target", value);
            return this;
        }

        public Builder objectAcl(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-object-acl", value);
            return this;
        }

        public Builder storageClass(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-storage-class", value);
            return this;
        }

        public Builder forbidOverwrite(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-forbid-overwrite", value);
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public PutSymlinkRequest build() {
            return new PutSymlinkRequest(this);
        }
    }
}

