/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.utils.MapUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;

public class RequestModel {
    protected Map<String, String> headers;
    protected Map<String, String> parameters;

    protected RequestModel(Builder<?> builder) {
        this.headers = Optional.ofNullable(builder.headers).orElse(new TreeMap(String.CASE_INSENSITIVE_ORDER));
        this.parameters = Optional.ofNullable(builder.parameters).orElse(new HashMap());
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    protected static class Builder<BuilderT> {
        protected Map<String, String> headers;
        protected Map<String, String> parameters;

        protected Builder() {
            this.headers = MapUtils.caseInsensitiveMap();
            this.parameters = MapUtils.caseSensitiveMap();
        }

        protected Builder(RequestModel request) {
            this.headers = request.headers;
            this.parameters = request.parameters;
        }

        public BuilderT headers(Map<String, String> value) {
            Objects.requireNonNull(value);
            this.headers.putAll(value);
            return (BuilderT)this;
        }

        public BuilderT parameters(Map<String, String> value) {
            Objects.requireNonNull(value);
            this.parameters.putAll(value);
            return (BuilderT)this;
        }

        public BuilderT header(String key, String value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.headers.put(key, value);
            return (BuilderT)this;
        }

        public BuilderT parameter(String key, String value) {
            Objects.requireNonNull(key);
            this.parameters.put(key, value);
            return (BuilderT)this;
        }
    }
}

