/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import com.aliyun.sdk.service.oss2.models.RestoreRequest;
import java.util.Objects;

public final class RestoreObjectRequest
extends RequestModel {
    private final String bucket;
    private final String key;
    private final RestoreRequest restoreRequest;

    private RestoreObjectRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.restoreRequest = builder.restoreRequest;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String versionId() {
        String value = (String)this.parameters.get("versionId");
        return value;
    }

    public RestoreRequest restoreRequest() {
        return this.restoreRequest;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;
        private RestoreRequest restoreRequest;

        private Builder() {
        }

        private Builder(RestoreObjectRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
            this.restoreRequest = request.restoreRequest;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder versionId(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("versionId", value);
            return this;
        }

        public Builder restoreRequest(RestoreRequest value) {
            Objects.requireNonNull(value);
            this.restoreRequest = value;
            return this;
        }

        public RestoreObjectRequest build() {
            return new RestoreObjectRequest(this);
        }
    }
}

