/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import java.util.Objects;

public final class SealAppendObjectRequest
extends RequestModel {
    private final String bucket;
    private final String key;
    private final String position;

    private SealAppendObjectRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.position = builder.position;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String position() {
        return this.position;
    }

    public String tagging() {
        String value = (String)this.headers.get("x-oss-tagging");
        return value;
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;
        private String position;

        private Builder() {
        }

        private Builder(SealAppendObjectRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
            this.position = request.position;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder position(String value) {
            Objects.requireNonNull(value);
            this.position = value;
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public SealAppendObjectRequest build() {
            return new SealAppendObjectRequest(this);
        }
    }
}

