/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import com.aliyun.sdk.service.oss2.utils.ConvertUtils;
import java.util.Objects;

public final class UploadPartCopyRequest
extends RequestModel {
    private final String bucket;
    private final String key;
    private final String sourceBucket;
    private final String sourceKey;
    private final String sourceVersionId;

    private UploadPartCopyRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.sourceBucket = builder.sourceBucket;
        this.sourceKey = builder.sourceKey;
        this.sourceVersionId = builder.sourceVersionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String sourceBucket() {
        return this.sourceBucket;
    }

    public String sourceKey() {
        return this.sourceKey;
    }

    public String sourceVersionId() {
        return this.sourceVersionId;
    }

    public String copySourceRange() {
        String value = (String)this.headers.get("x-oss-copy-source-range");
        return value;
    }

    public String copySourceIfMatch() {
        String value = (String)this.headers.get("x-oss-copy-source-if-match");
        return value;
    }

    public String copySourceIfNoneMatch() {
        String value = (String)this.headers.get("x-oss-copy-source-if-none-match");
        return value;
    }

    public String copySourceIfUnmodifiedSince() {
        String value = (String)this.headers.get("x-oss-copy-source-if-unmodified-since");
        return value;
    }

    public String copySourceIfModifiedSince() {
        String value = (String)this.headers.get("x-oss-copy-source-if-modified-since");
        return value;
    }

    public Long partNumber() {
        String value = (String)this.parameters.get("partNumber");
        return ConvertUtils.toLongOrNull(value);
    }

    public String uploadId() {
        String value = (String)this.parameters.get("uploadId");
        return value;
    }

    public Long trafficLimit() {
        String value = (String)this.headers.get("x-oss-traffic-limit");
        return ConvertUtils.toLongOrNull(value);
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;
        private String sourceBucket;
        private String sourceKey;
        private String sourceVersionId;

        private Builder() {
        }

        private Builder(UploadPartCopyRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
            this.sourceBucket = request.sourceBucket;
            this.sourceKey = request.sourceKey;
            this.sourceVersionId = request.sourceVersionId;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder sourceBucket(String value) {
            Objects.requireNonNull(value);
            this.sourceBucket = value;
            return this;
        }

        public Builder sourceKey(String value) {
            Objects.requireNonNull(value);
            this.sourceKey = value;
            return this;
        }

        public Builder sourceVersionId(String value) {
            Objects.requireNonNull(value);
            this.sourceVersionId = value;
            return this;
        }

        public Builder copySourceRange(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-copy-source-range", value);
            return this;
        }

        public Builder copySourceIfMatch(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-copy-source-if-match", value);
            return this;
        }

        public Builder copySourceIfNoneMatch(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-copy-source-if-none-match", value);
            return this;
        }

        public Builder copySourceIfUnmodifiedSince(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-copy-source-if-unmodified-since", value);
            return this;
        }

        public Builder copySourceIfModifiedSince(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-copy-source-if-modified-since", value);
            return this;
        }

        public Builder partNumber(Long value) {
            Objects.requireNonNull(value);
            this.parameters.put("partNumber", value.toString());
            return this;
        }

        public Builder uploadId(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("uploadId", value);
            return this;
        }

        public Builder trafficLimit(Long value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-traffic-limit", value.toString());
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public UploadPartCopyRequest build() {
            return new UploadPartCopyRequest(this);
        }
    }
}

