/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import com.aliyun.sdk.service.oss2.progress.ProgressListener;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.utils.ConvertUtils;
import java.util.Objects;

public final class UploadPartRequest
extends RequestModel {
    private final String bucket;
    private final String key;
    private final BinaryData body;
    private final ProgressListener progressListener;

    private UploadPartRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.body = builder.body;
        this.progressListener = builder.progressListener;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public Long partNumber() {
        String value = (String)this.parameters.get("partNumber");
        return ConvertUtils.toLongOrNull(value);
    }

    public String uploadId() {
        String value = (String)this.parameters.get("uploadId");
        return value;
    }

    public String contentMD5() {
        String value = (String)this.headers.get("Content-MD5");
        return value;
    }

    public Long contentLength() {
        String value = (String)this.headers.get("Content-Length");
        return ConvertUtils.toLongOrNull(value);
    }

    public Long trafficLimit() {
        String value = (String)this.headers.get("x-oss-traffic-limit");
        return ConvertUtils.toLongOrNull(value);
    }

    public String requestPayer() {
        String value = (String)this.headers.get("x-oss-request-payer");
        return value;
    }

    public BinaryData body() {
        return this.body;
    }

    public ProgressListener progressListener() {
        return this.progressListener;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;
        private String key;
        private BinaryData body;
        private ProgressListener progressListener;

        private Builder() {
        }

        private Builder(UploadPartRequest request) {
            super(request);
            this.bucket = request.bucket;
            this.key = request.key;
            this.body = request.body;
            this.progressListener = request.progressListener;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder key(String value) {
            Objects.requireNonNull(value);
            this.key = value;
            return this;
        }

        public Builder partNumber(Long value) {
            Objects.requireNonNull(value);
            this.parameters.put("partNumber", value.toString());
            return this;
        }

        public Builder uploadId(String value) {
            Objects.requireNonNull(value);
            this.parameters.put("uploadId", value);
            return this;
        }

        public Builder contentMD5(String value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-MD5", value);
            return this;
        }

        public Builder contentLength(Long value) {
            Objects.requireNonNull(value);
            this.headers.put("Content-Length", value.toString());
            return this;
        }

        public Builder trafficLimit(Long value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-traffic-limit", value.toString());
            return this;
        }

        public Builder requestPayer(String value) {
            Objects.requireNonNull(value);
            this.headers.put("x-oss-request-payer", value);
            return this;
        }

        public Builder body(BinaryData value) {
            Objects.requireNonNull(value);
            this.body = value;
            return this;
        }

        public Builder progressListener(ProgressListener progressListener) {
            Objects.requireNonNull(progressListener);
            this.progressListener = progressListener;
            return this;
        }

        public UploadPartRequest build() {
            return new UploadPartRequest(this);
        }
    }
}

