/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.operations;

import com.aliyun.sdk.service.oss2.AttributeKey;
import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOptions;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.exceptions.InconsistentException;
import com.aliyun.sdk.service.oss2.hash.CRC64Observer;
import com.aliyun.sdk.service.oss2.internal.ClientImpl;
import com.aliyun.sdk.service.oss2.io.StreamObserver;
import com.aliyun.sdk.service.oss2.models.AppendObjectRequest;
import com.aliyun.sdk.service.oss2.models.AppendObjectResult;
import com.aliyun.sdk.service.oss2.models.CleanRestoredObjectRequest;
import com.aliyun.sdk.service.oss2.models.CleanRestoredObjectResult;
import com.aliyun.sdk.service.oss2.models.CopyObjectRequest;
import com.aliyun.sdk.service.oss2.models.CopyObjectResult;
import com.aliyun.sdk.service.oss2.models.DeleteMultipleObjectsRequest;
import com.aliyun.sdk.service.oss2.models.DeleteMultipleObjectsResult;
import com.aliyun.sdk.service.oss2.models.DeleteObjectRequest;
import com.aliyun.sdk.service.oss2.models.DeleteObjectResult;
import com.aliyun.sdk.service.oss2.models.GetObjectMetaRequest;
import com.aliyun.sdk.service.oss2.models.GetObjectMetaResult;
import com.aliyun.sdk.service.oss2.models.GetObjectRequest;
import com.aliyun.sdk.service.oss2.models.GetObjectResult;
import com.aliyun.sdk.service.oss2.models.HeadObjectRequest;
import com.aliyun.sdk.service.oss2.models.HeadObjectResult;
import com.aliyun.sdk.service.oss2.models.PutObjectRequest;
import com.aliyun.sdk.service.oss2.models.PutObjectResult;
import com.aliyun.sdk.service.oss2.models.RestoreObjectRequest;
import com.aliyun.sdk.service.oss2.models.RestoreObjectResult;
import com.aliyun.sdk.service.oss2.models.SealAppendObjectRequest;
import com.aliyun.sdk.service.oss2.models.SealAppendObjectResult;
import com.aliyun.sdk.service.oss2.progress.ProgressObserver;
import com.aliyun.sdk.service.oss2.transform.SerdeObjectBasic;
import com.aliyun.sdk.service.oss2.types.FeatureFlagsType;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class ObjectBasic {
    public static PutObjectResult putObject(ClientImpl impl, PutObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromPutObject(request, impl.getFeatureFlags());
        OperationOutput output = impl.execute(input, options);
        return SerdeObjectBasic.toPutObject(output);
    }

    public static CompletableFuture<PutObjectResult> putObjectAsync(ClientImpl impl, PutObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromPutObject(request, impl.getFeatureFlags());
        return impl.executeAsync(input, options).thenApply(SerdeObjectBasic::toPutObject);
    }

    public static CopyObjectResult copyObject(ClientImpl impl, CopyObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.sourceKey(), "request.sourceKey is required");
        OperationInput input = SerdeObjectBasic.fromCopyObject(request);
        OperationOutput output = impl.execute(input, options);
        return SerdeObjectBasic.toCopyObject(output);
    }

    public static CompletableFuture<CopyObjectResult> copyObjectAsync(ClientImpl impl, CopyObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.sourceKey(), "request.sourceKey is required");
        OperationInput input = SerdeObjectBasic.fromCopyObject(request);
        return impl.executeAsync(input, options).thenApply(SerdeObjectBasic::toCopyObject);
    }

    public static GetObjectResult getObject(ClientImpl impl, GetObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromGetObject(request);
        input.opMetadata().put(AttributeKey.RESPONSE_HEADERS_READ, Boolean.TRUE);
        OperationOutput output = impl.execute(input, options);
        return SerdeObjectBasic.toGetObject(output);
    }

    public static CompletableFuture<GetObjectResult> getObjectAsync(ClientImpl impl, GetObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromGetObject(request);
        return impl.executeAsync(input, options).thenApply(SerdeObjectBasic::toGetObject);
    }

    public static AppendObjectResult appendObject(ClientImpl impl, AppendObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.position(), "request.position is required");
        int featureFlags = impl.getFeatureFlags();
        OperationInput input = SerdeObjectBasic.fromAppendObject(request, featureFlags);
        ArrayList<StreamObserver> streamObservers = null;
        if (request.progressListener() != null) {
            streamObservers = new ArrayList<StreamObserver>();
            streamObservers.add(new ProgressObserver(request.progressListener(), request.body().getLength()));
        }
        CRC64Observer crcObserver = null;
        if (request.initHashCRC64() != null && FeatureFlagsType.ENABLE_CRC64_CHECK_UPLOAD.isSet(featureFlags)) {
            if (streamObservers == null) {
                streamObservers = new ArrayList();
            }
            crcObserver = new CRC64Observer(request.initHashCRC64());
            streamObservers.add(crcObserver);
        }
        if (streamObservers != null) {
            input.opMetadata().put(AttributeKey.UPLOAD_OBSERVER, streamObservers);
        }
        OperationOutput output = impl.execute(input, options);
        ObjectBasic.checkResponseCrc(crcObserver, output.headers());
        return SerdeObjectBasic.toAppendObject(output);
    }

    public static CompletableFuture<AppendObjectResult> appendObjectAsync(ClientImpl impl, AppendObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.position(), "request.position is required");
        int featureFlags = impl.getFeatureFlags();
        OperationInput input = SerdeObjectBasic.fromAppendObject(request, featureFlags);
        ArrayList<StreamObserver> streamObservers = null;
        if (request.progressListener() != null) {
            streamObservers = new ArrayList<StreamObserver>();
            streamObservers.add(new ProgressObserver(request.progressListener(), request.body().getLength()));
        }
        CRC64Observer crcObserver = null;
        if (request.initHashCRC64() != null && FeatureFlagsType.ENABLE_CRC64_CHECK_UPLOAD.isSet(featureFlags)) {
            if (streamObservers == null) {
                streamObservers = new ArrayList();
            }
            crcObserver = new CRC64Observer(request.initHashCRC64());
            streamObservers.add(crcObserver);
        }
        if (streamObservers != null) {
            input.opMetadata().put(AttributeKey.UPLOAD_OBSERVER, streamObservers);
        }
        CRC64Observer crcChecker = crcObserver;
        return impl.executeAsync(input, options).thenApply(output -> {
            ObjectBasic.checkResponseCrc(crcChecker, output.headers());
            return SerdeObjectBasic.toAppendObject(output);
        });
    }

    public static DeleteObjectResult deleteObject(ClientImpl impl, DeleteObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromDeleteObject(request);
        OperationOutput output = impl.execute(input, options);
        return SerdeObjectBasic.toDeleteObject(output);
    }

    public static CompletableFuture<DeleteObjectResult> deleteObjectAsync(ClientImpl impl, DeleteObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromDeleteObject(request);
        return impl.executeAsync(input, options).thenApply(SerdeObjectBasic::toDeleteObject);
    }

    public static DeleteMultipleObjectsResult deleteMultipleObjects(ClientImpl impl, DeleteMultipleObjectsRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        OperationInput input = SerdeObjectBasic.fromDeleteMultipleObjects(request);
        OperationOutput output = impl.execute(input, options);
        return SerdeObjectBasic.toDeleteMultipleObjects(output);
    }

    public static CompletableFuture<DeleteMultipleObjectsResult> deleteMultipleObjectsAsync(ClientImpl impl, DeleteMultipleObjectsRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        OperationInput input = SerdeObjectBasic.fromDeleteMultipleObjects(request);
        return impl.executeAsync(input, options).thenApply(SerdeObjectBasic::toDeleteMultipleObjects);
    }

    public static HeadObjectResult headObject(ClientImpl impl, HeadObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromHeadObject(request);
        OperationOutput output = impl.execute(input, options);
        return SerdeObjectBasic.toHeadObject(output);
    }

    public static CompletableFuture<HeadObjectResult> headObjectAsync(ClientImpl impl, HeadObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromHeadObject(request);
        return impl.executeAsync(input, options).thenApply(SerdeObjectBasic::toHeadObject);
    }

    public static GetObjectMetaResult getObjectMeta(ClientImpl impl, GetObjectMetaRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromGetObjectMeta(request);
        OperationOutput output = impl.execute(input, options);
        return SerdeObjectBasic.toGetObjectMeta(output);
    }

    public static CompletableFuture<GetObjectMetaResult> getObjectMetaAsync(ClientImpl impl, GetObjectMetaRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromGetObjectMeta(request);
        return impl.executeAsync(input, options).thenApply(SerdeObjectBasic::toGetObjectMeta);
    }

    public static RestoreObjectResult restoreObject(ClientImpl impl, RestoreObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromRestoreObject(request);
        OperationOutput output = impl.execute(input, options);
        return SerdeObjectBasic.toRestoreObject(output);
    }

    public static CompletableFuture<RestoreObjectResult> restoreObjectAsync(ClientImpl impl, RestoreObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromRestoreObject(request);
        return impl.executeAsync(input, options).thenApply(SerdeObjectBasic::toRestoreObject);
    }

    public static CleanRestoredObjectResult cleanRestoredObject(ClientImpl impl, CleanRestoredObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromCleanRestoredObject(request);
        OperationOutput output = impl.execute(input, options);
        return SerdeObjectBasic.toCleanRestoredObject(output);
    }

    public static CompletableFuture<CleanRestoredObjectResult> cleanRestoredObjectAsync(ClientImpl impl, CleanRestoredObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = SerdeObjectBasic.fromCleanRestoredObject(request);
        return impl.executeAsync(input, options).thenApply(SerdeObjectBasic::toCleanRestoredObject);
    }

    private static void checkResponseCrc(CRC64Observer observer, Map<String, String> headers) {
        if (observer == null || headers == null) {
            return;
        }
        String serverCRC = headers.get("x-oss-hash-crc64ecma");
        if (serverCRC == null) {
            return;
        }
        String clientCRC = Long.toUnsignedString(observer.getChecksum().getValue());
        if (!serverCRC.equals(clientCRC)) {
            throw new InconsistentException(clientCRC, serverCRC, headers);
        }
    }

    public static SealAppendObjectResult sealAppendObject(ClientImpl impl, SealAppendObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.position(), "request.position is required");
        OperationInput input = SerdeObjectBasic.fromSealAppendObject(request);
        OperationOutput output = impl.execute(input, options);
        return SerdeObjectBasic.toSealAppendObject(output);
    }

    public static CompletableFuture<SealAppendObjectResult> sealAppendObjectAsync(ClientImpl impl, SealAppendObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.position(), "request.position is required");
        OperationInput input = SerdeObjectBasic.fromSealAppendObject(request);
        return impl.executeAsync(input, options).thenApply(SerdeObjectBasic::toSealAppendObject);
    }
}

