/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.operations;

import com.aliyun.sdk.service.oss2.AttributeKey;
import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOptions;
import com.aliyun.sdk.service.oss2.PresignOptions;
import com.aliyun.sdk.service.oss2.internal.ClientImpl;
import com.aliyun.sdk.service.oss2.models.AbortMultipartUploadRequest;
import com.aliyun.sdk.service.oss2.models.CompleteMultipartUploadRequest;
import com.aliyun.sdk.service.oss2.models.GetObjectRequest;
import com.aliyun.sdk.service.oss2.models.HeadObjectRequest;
import com.aliyun.sdk.service.oss2.models.InitiateMultipartUploadRequest;
import com.aliyun.sdk.service.oss2.models.PresignResult;
import com.aliyun.sdk.service.oss2.models.PutObjectRequest;
import com.aliyun.sdk.service.oss2.models.UploadPartRequest;
import com.aliyun.sdk.service.oss2.transform.SerdeUtils;
import com.aliyun.sdk.service.oss2.types.AuthMethodType;
import com.aliyun.sdk.service.oss2.utils.MapUtils;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public class Presigner {
    private static final OperationOptions defaultPresignOpOpt = OperationOptions.newBuilder().authMethod(AuthMethodType.Query).build();

    private static PresignResult doPresign(ClientImpl impl, OperationInput input, PresignOptions options) {
        if (options != null && options.expiration().isPresent()) {
            input.opMetadata().put(AttributeKey.EXPIRATION_TIME, options.expiration().get());
        }
        ClientImpl.PresignInnerResult result = impl.presignInner(input, defaultPresignOpOpt);
        return PresignResult.newBuilder().url(result.url).method(result.method).expiration(result.expiration).signedHeaders(result.signedHeaders).build();
    }

    public static PresignResult putObject(ClientImpl impl, PutObjectRequest request, PresignOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = OperationInput.newBuilder().opName("PutObject").method("PUT").bucket(request.bucket()).key(request.key()).build();
        SerdeUtils.serializeInput(request, input, new BiConsumer[0]);
        return Presigner.doPresign(impl, input, options);
    }

    public static PresignResult getObject(ClientImpl impl, GetObjectRequest request, PresignOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = OperationInput.newBuilder().opName("GetObject").method("GET").bucket(request.bucket()).key(request.key()).build();
        SerdeUtils.serializeInput(request, input, new BiConsumer[0]);
        return Presigner.doPresign(impl, input, options);
    }

    public static PresignResult headObject(ClientImpl impl, HeadObjectRequest request, PresignOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput input = OperationInput.newBuilder().opName("HeadObject").method("HEAD").bucket(request.bucket()).key(request.key()).build();
        SerdeUtils.serializeInput(request, input, new BiConsumer[0]);
        return Presigner.doPresign(impl, input, options);
    }

    public static PresignResult initiateMultipartUpload(ClientImpl impl, InitiateMultipartUploadRequest request, PresignOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        OperationInput.Builder builder = OperationInput.newBuilder().opName("InitiateMultipartUpload").method("POST").bucket(request.bucket()).key(request.key());
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("uploads", "");
        builder.parameters(parameters);
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, new BiConsumer[0]);
        return Presigner.doPresign(impl, input, options);
    }

    public static PresignResult uploadPart(ClientImpl impl, UploadPartRequest request, PresignOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.uploadId(), "request.uploadId is required");
        Objects.requireNonNull(request.partNumber(), "request.partNumber is required");
        OperationInput input = OperationInput.newBuilder().opName("UploadPart").method("PUT").bucket(request.bucket()).key(request.key()).build();
        SerdeUtils.serializeInput(request, input, new BiConsumer[0]);
        return Presigner.doPresign(impl, input, options);
    }

    public static PresignResult completeMultipartUpload(ClientImpl impl, CompleteMultipartUploadRequest request, PresignOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.uploadId(), "request.uploadId is required");
        OperationInput input = OperationInput.newBuilder().opName("CompleteMultipartUpload").method("POST").bucket(request.bucket()).key(request.key()).build();
        SerdeUtils.serializeInput(request, input, new BiConsumer[0]);
        return Presigner.doPresign(impl, input, options);
    }

    public static PresignResult abortMultipartUpload(ClientImpl impl, AbortMultipartUploadRequest request, PresignOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.uploadId(), "request.uploadId is required");
        OperationInput input = OperationInput.newBuilder().opName("AbortMultipartUpload").method("DELETE").bucket(request.bucket()).key(request.key()).build();
        SerdeUtils.serializeInput(request, input, new BiConsumer[0]);
        return Presigner.doPresign(impl, input, options);
    }
}

