/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.operations;

import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOptions;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.internal.ClientImpl;
import com.aliyun.sdk.service.oss2.models.AsyncProcessObjectRequest;
import com.aliyun.sdk.service.oss2.models.AsyncProcessObjectResult;
import com.aliyun.sdk.service.oss2.models.ProcessObjectRequest;
import com.aliyun.sdk.service.oss2.models.ProcessObjectResult;
import com.aliyun.sdk.service.oss2.transform.SerdeProcessObject;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class ProcessObject {
    public static ProcessObjectResult processObject(ClientImpl impl, ProcessObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.process(), "request.process is required");
        OperationInput input = SerdeProcessObject.fromProcessObject(request);
        OperationOutput output = impl.execute(input, options);
        return SerdeProcessObject.toProcessObject(output);
    }

    public static CompletableFuture<ProcessObjectResult> processObjectAsync(ClientImpl impl, ProcessObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.process(), "request.process is required");
        OperationInput input = SerdeProcessObject.fromProcessObject(request);
        return impl.executeAsync(input, options).thenApply(SerdeProcessObject::toProcessObject);
    }

    public static AsyncProcessObjectResult asyncProcessObject(ClientImpl impl, AsyncProcessObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.process(), "request.process is required");
        OperationInput input = SerdeProcessObject.fromAsyncProcessObject(request);
        OperationOutput output = impl.execute(input, options);
        return SerdeProcessObject.toAsyncProcessObject(output);
    }

    public static CompletableFuture<AsyncProcessObjectResult> asyncProcessObjectAsync(ClientImpl impl, AsyncProcessObjectRequest request, OperationOptions options) {
        Objects.requireNonNull(request.bucket(), "request.bucket is required");
        Objects.requireNonNull(request.key(), "request.key is required");
        Objects.requireNonNull(request.process(), "request.process is required");
        OperationInput input = SerdeProcessObject.fromAsyncProcessObject(request);
        return impl.executeAsync(input, options).thenApply(SerdeProcessObject::toAsyncProcessObject);
    }
}

