/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.paginator;

import com.aliyun.sdk.service.oss2.OSSClient;
import com.aliyun.sdk.service.oss2.models.ListMultipartUploadsRequest;
import com.aliyun.sdk.service.oss2.models.ListMultipartUploadsResult;
import com.aliyun.sdk.service.oss2.paginator.PaginatedIterable;
import com.aliyun.sdk.service.oss2.paginator.PaginatorOptions;
import com.aliyun.sdk.service.oss2.utils.StringUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public class ListMultipartUploadsIterable
implements PaginatedIterable<ListMultipartUploadsResult> {
    private final OSSClient client;
    private final ListMultipartUploadsRequest firstRequest;

    public ListMultipartUploadsIterable(OSSClient client, ListMultipartUploadsRequest request) {
        this(client, request, PaginatorOptions.defaults());
    }

    public ListMultipartUploadsIterable(OSSClient client, ListMultipartUploadsRequest request, PaginatorOptions options) {
        Objects.requireNonNull(client);
        Objects.requireNonNull(request);
        this.client = client;
        this.firstRequest = this.applyRequest(request, options);
    }

    ListMultipartUploadsRequest applyRequest(ListMultipartUploadsRequest request, PaginatorOptions options) {
        if (options.limit().isPresent()) {
            return request.toBuilder().maxUploads(options.limit().get()).build();
        }
        return request;
    }

    ListMultipartUploadsRequest cloneRequest() {
        return ((ListMultipartUploadsRequest.Builder)((ListMultipartUploadsRequest.Builder)ListMultipartUploadsRequest.newBuilder().bucket(this.firstRequest.bucket()).headers(this.firstRequest.headers())).parameters(this.firstRequest.parameters())).build();
    }

    @Override
    public Iterator<ListMultipartUploadsResult> iterator() {
        return new IteratorImpl(this.cloneRequest());
    }

    private class IteratorImpl
    implements Iterator<ListMultipartUploadsResult> {
        private boolean firstPage = true;
        private boolean isTruncated = false;
        private String nextKeyMarker = null;
        private String nextUploadIdMarker = null;
        private ListMultipartUploadsRequest request;

        IteratorImpl(ListMultipartUploadsRequest request) {
            this.request = request;
        }

        @Override
        public boolean hasNext() {
            return this.firstPage || this.isTruncated;
        }

        @Override
        public ListMultipartUploadsResult next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more pages left");
            }
            if (!StringUtils.isNullOrEmpty(this.nextKeyMarker)) {
                this.request = this.request.toBuilder().keyMarker(this.nextKeyMarker).uploadIdMarker(this.nextUploadIdMarker).build();
            }
            ListMultipartUploadsResult result = ListMultipartUploadsIterable.this.client.listMultipartUploads(this.request);
            this.firstPage = false;
            this.isTruncated = Optional.ofNullable(result.isTruncated()).orElse(false);
            this.nextKeyMarker = result.nextKeyMarker();
            this.nextUploadIdMarker = result.nextUploadIdMarker();
            return result;
        }
    }
}

