/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.paginator;

import com.aliyun.sdk.service.oss2.OSSClient;
import com.aliyun.sdk.service.oss2.models.ListObjectsRequest;
import com.aliyun.sdk.service.oss2.models.ListObjectsResult;
import com.aliyun.sdk.service.oss2.paginator.PaginatedIterable;
import com.aliyun.sdk.service.oss2.paginator.PaginatorOptions;
import com.aliyun.sdk.service.oss2.utils.StringUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public class ListObjectsIterable
implements PaginatedIterable<ListObjectsResult> {
    private final OSSClient client;
    private final ListObjectsRequest firstRequest;

    public ListObjectsIterable(OSSClient client, ListObjectsRequest request) {
        this(client, request, PaginatorOptions.defaults());
    }

    public ListObjectsIterable(OSSClient client, ListObjectsRequest request, PaginatorOptions options) {
        Objects.requireNonNull(client);
        Objects.requireNonNull(request);
        this.client = client;
        this.firstRequest = this.applyRequest(request, options);
    }

    ListObjectsRequest applyRequest(ListObjectsRequest request, PaginatorOptions options) {
        if (options.limit().isPresent()) {
            return request.toBuilder().maxKeys(options.limit().get()).build();
        }
        return request;
    }

    ListObjectsRequest cloneRequest() {
        return ((ListObjectsRequest.Builder)((ListObjectsRequest.Builder)ListObjectsRequest.newBuilder().bucket(this.firstRequest.bucket()).headers(this.firstRequest.headers())).parameters(this.firstRequest.parameters())).build();
    }

    @Override
    public Iterator<ListObjectsResult> iterator() {
        return new IteratorImpl(this.cloneRequest());
    }

    private class IteratorImpl
    implements Iterator<ListObjectsResult> {
        private boolean firstPage = true;
        private boolean isTruncated = false;
        private String nextMarker = null;
        private ListObjectsRequest request;

        IteratorImpl(ListObjectsRequest request) {
            this.request = request;
        }

        @Override
        public boolean hasNext() {
            return this.firstPage || this.isTruncated;
        }

        @Override
        public ListObjectsResult next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more pages left");
            }
            if (!StringUtils.isNullOrEmpty(this.nextMarker)) {
                this.request = this.request.toBuilder().marker(this.nextMarker).build();
            }
            ListObjectsResult result = ListObjectsIterable.this.client.listObjects(this.request);
            this.firstPage = false;
            this.isTruncated = Optional.ofNullable(result.isTruncated()).orElse(false);
            this.nextMarker = result.nextMarker();
            return result;
        }
    }
}

