/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.progress;

import com.aliyun.sdk.service.oss2.io.StreamObserver;
import com.aliyun.sdk.service.oss2.progress.ProgressListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.Optional;

public class ProgressObserver
extends StreamObserver
implements WritableByteChannel {
    private final ProgressListener listener;
    private final long total;
    private long written;
    private long lastWritten;

    public ProgressObserver(ProgressListener listener) {
        this(listener, -1L);
    }

    public ProgressObserver(ProgressListener listener, Long total) {
        Objects.requireNonNull(listener);
        this.listener = listener;
        this.total = Optional.ofNullable(total).orElse(-1L);
    }

    private void notify(long inc) {
        if (this.written > this.lastWritten) {
            this.listener.onProgress(inc, this.written, this.total);
        }
    }

    @Override
    public void data(byte[] buffer, int offset, int length) throws IOException {
        this.written += (long)length;
        this.notify(length);
    }

    @Override
    public void data(int value) throws IOException {
        ++this.written;
        this.notify(1L);
    }

    @Override
    public void finished() throws IOException {
        this.listener.onFinish();
    }

    @Override
    public void reset() {
        this.lastWritten = this.written;
        this.written = 0L;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int len = src.limit() - src.position();
        src.position(src.limit());
        this.notify(len);
        return len;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

