/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.retry;

import com.aliyun.sdk.service.oss2.retry.BackoffDelayer;
import java.time.Duration;
import java.util.Random;

public class FullJitterBackoff
implements BackoffDelayer {
    private final int RETRIES_ATTEMPTED_CEILING = (int)Math.floor(Math.log(2.147483647E9) / Math.log(2.0));
    private final Duration baseDelay;
    private final Duration maxBackoff;
    private final Random random;

    public FullJitterBackoff(Duration baseDelay, Duration maxBackoff) {
        this.baseDelay = baseDelay;
        this.maxBackoff = maxBackoff;
        this.random = new Random();
    }

    @Override
    public Duration backoffDelay(int attempt, Throwable error) {
        attempt = Math.min(attempt, this.RETRIES_ATTEMPTED_CEILING);
        int ceil = (int)Math.min(this.baseDelay.multipliedBy(1L << attempt).toMillis(), this.maxBackoff.toMillis());
        return Duration.ofMillis(this.random.nextInt(ceil));
    }

    public String toString() {
        return String.format("<FullJitterBackoff, base delay: '%s', max backoff: '%s'>", this.baseDelay, this.maxBackoff);
    }
}

