/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.retry;

import com.aliyun.sdk.service.oss2.exceptions.ServiceException;
import com.aliyun.sdk.service.oss2.retry.ErrorRetryable;

public class HTTPStatusCodeRetryable
implements ErrorRetryable {
    private static final int[] statusCodes = new int[]{401, 408, 429};

    @Override
    public boolean isErrorRetryable(Throwable error) {
        if (error instanceof ServiceException) {
            int statusCode = ((ServiceException)error).statusCode();
            if (statusCode >= 500) {
                return true;
            }
            for (int code : statusCodes) {
                if (code != statusCode) continue;
                return true;
            }
        }
        return false;
    }
}

