/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.retry;

import com.aliyun.sdk.service.oss2.Defaults;
import com.aliyun.sdk.service.oss2.retry.BackoffDelayer;
import com.aliyun.sdk.service.oss2.retry.ClientErrorRetryable;
import com.aliyun.sdk.service.oss2.retry.ErrorRetryable;
import com.aliyun.sdk.service.oss2.retry.FullJitterBackoff;
import com.aliyun.sdk.service.oss2.retry.HTTPStatusCodeRetryable;
import com.aliyun.sdk.service.oss2.retry.Retryer;
import com.aliyun.sdk.service.oss2.retry.ServiceErrorCodeRetryable;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class StandardRetryer
implements Retryer {
    private final int maxAttempts;
    private final List<ErrorRetryable> errorRetryable;
    private final BackoffDelayer backoffDelayer;

    private StandardRetryer(Builder builder) {
        this.maxAttempts = Optional.ofNullable(builder.maxAttempts).orElse(3);
        this.errorRetryable = Optional.ofNullable(builder.errorRetryable).orElse(Arrays.asList(new HTTPStatusCodeRetryable(), new ServiceErrorCodeRetryable(), new ClientErrorRetryable()));
        this.backoffDelayer = Optional.ofNullable(builder.backoffDelayer).orElse(new FullJitterBackoff(Defaults.BASE_DELAY, Defaults.MAX_BACKOFF));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public boolean isErrorRetryable(Throwable error) {
        for (ErrorRetryable retryable : this.errorRetryable) {
            if (!retryable.isErrorRetryable(error)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int maxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public Duration retryDelay(int attempt, Throwable error) {
        return this.backoffDelayer.backoffDelay(attempt, error);
    }

    public static class Builder {
        private Integer maxAttempts;
        private List<ErrorRetryable> errorRetryable;
        private BackoffDelayer backoffDelayer;

        private Builder() {
        }

        public Builder maxAttempts(Integer value) {
            this.maxAttempts = value;
            return this;
        }

        public Builder errorRetryable(List<ErrorRetryable> value) {
            this.errorRetryable = value;
            return this;
        }

        public Builder backoffDelayer(BackoffDelayer value) {
            this.backoffDelayer = value;
            return this;
        }

        public StandardRetryer build() {
            return new StandardRetryer(this);
        }
    }
}

