/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.signer;

import com.aliyun.sdk.service.oss2.credentials.Credentials;
import com.aliyun.sdk.service.oss2.signer.Signer;
import com.aliyun.sdk.service.oss2.signer.SigningContext;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import com.aliyun.sdk.service.oss2.utils.HttpUtils;
import com.aliyun.sdk.service.oss2.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignerV1
implements Signer {
    private static final List<String> SUBRESOURCE_KEY_SET = Arrays.asList("acl", "bucketInfo", "location", "stat", "delete", "append", "tagging", "objectMeta", "uploads", "uploadId", "partNumber", "security-token", "position", "response-content-type", "response-content-language", "response-expires", "response-cache-control", "response-content-disposition", "response-content-encoding", "restore", "callback", "callback-var", "versions", "versioning", "versionId", "sequential", "continuation-token", "regionList", "cloudboxes", "symlink", "resourceGroup", "cleanRestoredObject");

    public static boolean isSignedHeader(String header) {
        return SignerV1.isDefaultSignHeader(header.toLowerCase());
    }

    private static boolean isDefaultSignHeader(String key) {
        return key.startsWith("x-oss-") || key.equals("content-type") || key.equals("content-md5") || key.equals("date");
    }

    private static boolean isSignHeader(String key) {
        return key != null && key.startsWith("x-oss-");
    }

    private static String getDateFromHeaders(Map<String, String> headers) {
        String xOssDate = headers.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("x-oss-date")).map(Map.Entry::getValue).findFirst().orElse(null);
        String dateHeader = headers.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("date")).map(Map.Entry::getValue).findFirst().orElse(null);
        String date = xOssDate != null && !xOssDate.isEmpty() ? xOssDate : (dateHeader != null ? dateHeader : "");
        return date;
    }

    @Override
    public void sign(SigningContext signingCtx) {
        if (signingCtx == null) {
            throw new IllegalArgumentException("SigningContext is null");
        }
        if (signingCtx.getCredentials() == null) {
            throw new IllegalArgumentException("SigningContext.credentials is null");
        }
        if (signingCtx.getRequest() == null) {
            throw new IllegalArgumentException("SigningContext.request is null");
        }
        if (signingCtx.isAuthMethodQuery()) {
            this.authQuery(signingCtx);
        } else {
            this.authHeader(signingCtx);
        }
    }

    private void authHeader(SigningContext signingCtx) {
        RequestMessage request = signingCtx.getRequest();
        Credentials cred = signingCtx.getCredentials();
        ZonedDateTime datetimeNow = signingCtx.getSignTime() == null ? ZonedDateTime.now(ZoneId.of("UTC")) : signingCtx.getSignTime().atZone(ZoneId.of("UTC"));
        String dateRfc2822 = this.formatDateTimeRfc2822(datetimeNow);
        request.headers().put("Date", dateRfc2822);
        if (!StringUtils.isEmpty(cred.securityToken())) {
            request.headers().put("security-token", cred.securityToken());
        }
        String stringToSign = this.calcStringToSign(signingCtx, null);
        String signature = this.calcSignature(cred.accessKeySecret(), stringToSign);
        String credentialHeader = "OSS " + cred.accessKeyId() + ":" + signature;
        request.headers().put("Authorization", credentialHeader);
        signingCtx.setStringToSign(stringToSign);
        signingCtx.setSignTime(Instant.from(datetimeNow));
    }

    private void authQuery(SigningContext signingCtx) {
        RequestMessage request = signingCtx.getRequest();
        Credentials cred = signingCtx.getCredentials();
        ZonedDateTime datetimeNow = signingCtx.getSignTime() == null ? ZonedDateTime.now(ZoneId.of("UTC")) : signingCtx.getSignTime().atZone(ZoneId.of("UTC"));
        ZonedDateTime expirationTime = signingCtx.getExpiration() == null ? datetimeNow.plusMinutes(15L) : signingCtx.getExpiration().atZone(ZoneId.of("UTC"));
        String expires = String.valueOf(expirationTime.toEpochSecond());
        Map<String, String> parameters = HttpUtils.uriParams(request.uri());
        parameters.remove("Signature");
        parameters.remove("security-token");
        parameters.put("OSSAccessKeyId", cred.accessKeyId());
        parameters.put("Expires", expires);
        if (!StringUtils.isEmpty(cred.securityToken())) {
            parameters.put("security-token", cred.securityToken());
        }
        Optional<String> query = HttpUtils.encodeQueryParameters(parameters);
        StringBuilder url = new StringBuilder();
        url.append(request.uri().getScheme()).append("://").append(request.uri().getRawAuthority()).append(request.uri().getRawPath());
        query.ifPresent(s -> url.append("?").append((String)s));
        signingCtx.setRequest(request.toBuilder().uri(url.toString()).build());
        String stringToSign = this.calcStringToSign(signingCtx, expires);
        String signature = this.calcSignature(cred.accessKeySecret(), stringToSign);
        url.append("&Signature=").append(HttpUtils.urlEncode(signature));
        signingCtx.setRequest(request.toBuilder().uri(url.toString()).build());
        signingCtx.setStringToSign(stringToSign);
        signingCtx.setSignTime(Instant.from(datetimeNow));
        signingCtx.setExpiration(Instant.from(expirationTime));
    }

    private String calcStringToSign(SigningContext signingCtx, String date) {
        RequestMessage request = signingCtx.getRequest();
        String canonicalUri = "/";
        if (!StringUtils.isNullOrEmpty(signingCtx.getBucket())) {
            canonicalUri = canonicalUri + signingCtx.getBucket() + "/";
        }
        if (!StringUtils.isNullOrEmpty(signingCtx.getKey())) {
            canonicalUri = canonicalUri + signingCtx.getKey();
        }
        String canonicalQuery = "";
        Map<String, String> queryMap = HttpUtils.uriEncodedParams(request.uri());
        ArrayList<Map.Entry<String, String>> sortedEntries = new ArrayList<Map.Entry<String, String>>(queryMap.entrySet());
        Collections.sort(sortedEntries, Map.Entry.comparingByKey());
        ArrayList<String> queryParts = new ArrayList<String>();
        for (Map.Entry entry : sortedEntries) {
            String key = HttpUtils.urlDecode((String)entry.getKey());
            String value = HttpUtils.urlDecode((String)entry.getValue());
            if (!SUBRESOURCE_KEY_SET.contains(key) && (signingCtx.getSubResource() == null || !signingCtx.getSubResource().contains(key))) continue;
            if (!value.isEmpty()) {
                queryParts.add(key + "=" + value);
                continue;
            }
            queryParts.add(key);
        }
        if (!queryParts.isEmpty()) {
            canonicalQuery = "?" + String.join((CharSequence)"&", queryParts);
        }
        String canonicalResource = canonicalUri + canonicalQuery;
        String string = this.buildCanonicalHeaders(request.headers());
        String contentMd5 = "";
        String contentType = "";
        for (Map.Entry<String, String> entry : request.headers().entrySet()) {
            String key = entry.getKey().toLowerCase();
            if (key.equals("content-md5")) {
                contentMd5 = entry.getValue();
                continue;
            }
            if (!key.equals("content-type")) continue;
            contentType = entry.getValue();
        }
        String dateHeader = date != null ? date : SignerV1.getDateFromHeaders(request.headers());
        return String.join((CharSequence)"\n", request.method(), contentMd5, contentType, dateHeader, string + canonicalResource);
    }

    private String calcSignature(String accessKeySecret, String stringToSign) {
        try {
            Mac hmac = Mac.getInstance("HmacSHA1");
            SecretKeySpec keySpec = new SecretKeySpec(accessKeySecret.getBytes(StandardCharsets.UTF_8), "HmacSHA1");
            hmac.init(keySpec);
            byte[] signatureBytes = hmac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(signatureBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Failed to calculate signature", e);
        }
    }

    private String formatDateTimeRfc2822(ZonedDateTime zonedDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME;
        return zonedDateTime.format(formatter);
    }

    private String buildCanonicalHeaders(Map<String, String> headers) {
        HashMap<String, String> lowKeyMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry2 : headers.entrySet()) {
            String key = entry2.getKey().toLowerCase();
            if (entry2.getValue() == null || entry2.getValue().isEmpty() || !SignerV1.isSignHeader(key)) continue;
            lowKeyMap.put(key, entry2.getValue());
        }
        return lowKeyMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue() + "\n").collect(Collectors.joining());
    }
}

