/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.signer;

import com.aliyun.sdk.service.oss2.credentials.Credentials;
import com.aliyun.sdk.service.oss2.signer.Signer;
import com.aliyun.sdk.service.oss2.signer.SigningContext;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import com.aliyun.sdk.service.oss2.utils.HttpUtils;
import com.aliyun.sdk.service.oss2.utils.StringUtils;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignerV4
implements Signer {
    private static final String ISO8601_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    private static final String ALGORITHM = "HmacSHA256";
    private static final String SCOPE_FORMAT = "%s/%s/%s/aliyun_v4_request";

    private static boolean isDefaultSignHeader(String key) {
        return key.startsWith("x-oss-") || key.equals("content-type") || key.equals("content-md5");
    }

    @Override
    public void sign(SigningContext signingCtx) {
        if (signingCtx == null) {
            throw new IllegalArgumentException("SigningContext cannot be null");
        }
        if (signingCtx.getCredentials() == null) {
            throw new IllegalArgumentException("SigningContext.credentials is null");
        }
        RequestMessage request = signingCtx.getRequest();
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (signingCtx.isAuthMethodQuery()) {
            this.authQuery(signingCtx);
        } else {
            this.authHeader(signingCtx);
        }
    }

    private void authHeader(SigningContext signingCtx) {
        RequestMessage request = signingCtx.getRequest();
        Credentials cred = signingCtx.getCredentials();
        Instant now = this.getSignTime(signingCtx);
        String iso8601Date = now.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(ISO8601_FORMAT));
        String rfc2822Date = this.formatRfc2822(now);
        String dateScope = now.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        request.headers().put("x-oss-date", iso8601Date);
        request.headers().put("Date", rfc2822Date);
        if (cred.securityToken() != null && !cred.securityToken().isEmpty()) {
            request.headers().put("x-oss-security-token", cred.securityToken());
        }
        request.headers().put("x-oss-content-sha256", "UNSIGNED-PAYLOAD");
        String scope = this.buildScope(dateScope, signingCtx.getRegion(), signingCtx.getProduct());
        Set<String> additionalHeaders = this.commonAdditionalHeaders(request, signingCtx.getAdditionalHeaders());
        String region = signingCtx.getRegion() == null ? "" : signingCtx.getRegion();
        String product = signingCtx.getProduct() == null ? "" : signingCtx.getProduct();
        String canonicalRequest = this.calcCanonicalRequest(signingCtx, additionalHeaders);
        String stringToSign = this.calcStringToSign(iso8601Date, scope, canonicalRequest);
        String signature = this.calcSignature(cred.accessKeySecret(), dateScope, region, product, stringToSign);
        StringBuilder authHeader = new StringBuilder("OSS4-HMAC-SHA256 Credential=").append(cred.accessKeyId()).append("/").append(scope);
        if (!additionalHeaders.isEmpty()) {
            authHeader.append(",AdditionalHeaders=").append(String.join((CharSequence)";", additionalHeaders));
        }
        authHeader.append(",Signature=").append(signature);
        request.headers().put("Authorization", authHeader.toString());
        signingCtx.setStringToSign(stringToSign);
        signingCtx.setSignTime(now);
    }

    private void authQuery(SigningContext signingCtx) {
        RequestMessage request = signingCtx.getRequest();
        Credentials cred = signingCtx.getCredentials();
        Instant now = this.getSignTime(signingCtx);
        Instant expiration = this.getExpirationTime(signingCtx);
        String iso8601Date = now.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(ISO8601_FORMAT));
        String dateScope = now.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        long expires = Duration.between(now, expiration).getSeconds();
        String scope = this.buildScope(dateScope, signingCtx.getRegion(), signingCtx.getProduct());
        Set<String> additionalHeaders = this.commonAdditionalHeaders(request, signingCtx.getAdditionalHeaders());
        Map<String, String> parameters = HttpUtils.uriParams(request.uri());
        this.removeSignatureParams(parameters);
        parameters.put("x-oss-signature-version", "OSS4-HMAC-SHA256");
        parameters.put("x-oss-date", iso8601Date);
        parameters.put("x-oss-expires", String.valueOf(expires));
        parameters.put("x-oss-credential", cred.accessKeyId() + "/" + scope);
        if (cred.securityToken() != null && !cred.securityToken().isEmpty()) {
            parameters.put("x-oss-security-token", cred.securityToken());
        }
        if (!additionalHeaders.isEmpty()) {
            parameters.put("x-oss-additional-headers", String.join((CharSequence)";", additionalHeaders));
        }
        Optional<String> query = HttpUtils.encodeQueryParameters(parameters);
        StringBuilder url = new StringBuilder();
        url.append(request.uri().getScheme()).append("://").append(request.uri().getRawAuthority()).append(request.uri().getRawPath());
        query.ifPresent(s -> url.append("?").append((String)s));
        signingCtx.setRequest(request.toBuilder().uri(url.toString()).build());
        String region = signingCtx.getRegion() == null ? "" : signingCtx.getRegion();
        String product = signingCtx.getProduct() == null ? "" : signingCtx.getProduct();
        String signature = this.calcSignature(cred.accessKeySecret(), dateScope, region, product, this.calcStringToSign(iso8601Date, scope, this.calcCanonicalRequest(signingCtx, additionalHeaders)));
        url.append("&x-oss-signature=").append(HttpUtils.urlEncode(signature));
        signingCtx.setRequest(request.toBuilder().uri(url.toString()).build());
        signingCtx.setStringToSign(this.calcStringToSign(iso8601Date, scope, this.calcCanonicalRequest(signingCtx, additionalHeaders)));
        signingCtx.setSignTime(now);
        signingCtx.setExpiration(expiration);
    }

    private Instant getSignTime(SigningContext signingCtx) {
        if (signingCtx.getSignTime() == null) {
            return Instant.now();
        }
        return signingCtx.getSignTime();
    }

    private Instant getExpirationTime(SigningContext signingCtx) {
        if (signingCtx.getExpiration() == null) {
            return Instant.now().plus(15L, ChronoUnit.MINUTES);
        }
        return signingCtx.getExpiration();
    }

    private String buildScope(String date, String region, String product) {
        return String.format(SCOPE_FORMAT, date, region, product);
    }

    private Set<String> commonAdditionalHeaders(RequestMessage request, List<String> additionalHeaders) {
        TreeSet<String> result = new TreeSet<String>();
        if (additionalHeaders == null || request == null) {
            return result;
        }
        for (String additional : additionalHeaders) {
            String lowerKey = additional.toLowerCase();
            for (Map.Entry<String, String> header : request.headers().entrySet()) {
                String headerKey = header.getKey().toLowerCase();
                if (SignerV4.isDefaultSignHeader(lowerKey) || !headerKey.equals(lowerKey)) continue;
                result.add(lowerKey);
            }
        }
        return result;
    }

    private String calcCanonicalRequest(SigningContext signingCtx, Set<String> additionalHeaders) {
        RequestMessage request = signingCtx.getRequest();
        String canonicalUri = this.buildCanonicalUri(signingCtx);
        String canonicalQuery = this.buildCanonicalQuery(request.uri());
        String canonicalHeaders = this.buildCanonicalHeaders(request, additionalHeaders);
        String canonicalAdditional = String.join((CharSequence)";", additionalHeaders);
        String payloadHash = request.headers().getOrDefault("x-oss-content-sha256", "UNSIGNED-PAYLOAD");
        return String.join((CharSequence)"\n", request.method(), canonicalUri, canonicalQuery, canonicalHeaders, canonicalAdditional, payloadHash);
    }

    private String buildCanonicalUri(SigningContext signingCtx) {
        StringBuilder uri = new StringBuilder("/");
        if (!StringUtils.isNullOrEmpty(signingCtx.getBucket())) {
            uri.append(signingCtx.getBucket()).append("/");
        }
        if (!StringUtils.isNullOrEmpty(signingCtx.getKey())) {
            uri.append(signingCtx.getKey());
        }
        return HttpUtils.urlEncodePath(uri.toString());
    }

    private String buildCanonicalQuery(URI uri) {
        Map<String, String> queryMap = HttpUtils.uriEncodedParams(uri);
        return queryMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            return value.isEmpty() ? key : key + "=" + value;
        }).collect(Collectors.joining("&"));
    }

    private String buildCanonicalHeaders(RequestMessage request, Set<String> additionalHeaders) {
        HashMap<String, String> lowKeyMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry2 : request.headers().entrySet()) {
            String key = entry2.getKey().toLowerCase();
            if (entry2.getValue() == null || entry2.getValue().isEmpty() || !this.isSignHeader(key, additionalHeaders)) continue;
            lowKeyMap.put(key, entry2.getValue());
        }
        return lowKeyMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue() + "\n").collect(Collectors.joining());
    }

    private String calcStringToSign(String iso8601Date, String scope, String canonicalRequest) {
        String hash = this.sha256(canonicalRequest);
        return String.join((CharSequence)"\n", "OSS4-HMAC-SHA256", iso8601Date, scope, hash);
    }

    private String calcSignature(String accessKeySecret, String date, String region, String product, String stringToSign) {
        byte[] key = ("aliyun_v4" + accessKeySecret).getBytes(StandardCharsets.UTF_8);
        byte[] dateKey = this.hmacSha256(key, date.getBytes(StandardCharsets.UTF_8));
        byte[] regionKey = this.hmacSha256(dateKey, region.getBytes(StandardCharsets.UTF_8));
        byte[] productKey = this.hmacSha256(regionKey, product.getBytes(StandardCharsets.UTF_8));
        byte[] requestKey = this.hmacSha256(productKey, "aliyun_v4_request".getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = this.hmacSha256(requestKey, stringToSign.getBytes(StandardCharsets.UTF_8));
        return this.bytesToHex(signatureBytes);
    }

    private byte[] hmacSha256(byte[] key, byte[] data) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(key, ALGORITHM));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("HMAC calculation failed", e);
        }
    }

    private String hmacSha256Hex(byte[] key, byte[] data) {
        return this.bytesToHex(this.hmacSha256(key, data));
    }

    private String sha256(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return this.bytesToHex(digest.digest(input.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException("SHA256 calculation failed", e);
        }
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    private String formatRfc2822(Instant instant) {
        return instant.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME);
    }

    private void removeSignatureParams(Map<String, String> params) {
        params.remove("x-oss-signature");
        params.remove("x-oss-security-token");
        params.remove("x-oss-additional-headers");
    }

    private boolean isSignHeader(String key, Set<String> additionalHeaders) {
        return SignerV4.isDefaultSignHeader(key) || additionalHeaders != null && additionalHeaders.contains(key);
    }
}

