/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transform;

import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.models.AccessMonitorConfiguration;
import com.aliyun.sdk.service.oss2.models.GetBucketAccessMonitorRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketAccessMonitorResult;
import com.aliyun.sdk.service.oss2.models.PutBucketAccessMonitorRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketAccessMonitorResult;
import com.aliyun.sdk.service.oss2.transform.SerdeUtils;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.utils.MapUtils;
import java.util.Map;

public final class SerdeBucketAccessmonitor {
    public static OperationInput fromPutBucketAccessMonitor(PutBucketAccessMonitorRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("PutBucketAccessMonitor").method("PUT");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("accessmonitor", "");
        builder.parameters(parameters);
        BinaryData body = SerdeUtils.serializeXmlBody(request.accessMonitorConfiguration());
        builder.body(body);
        builder.bucket(request.bucket());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static PutBucketAccessMonitorResult toPutBucketAccessMonitor(OperationOutput output) {
        Object innerBody = null;
        return ((PutBucketAccessMonitorResult.Builder)((PutBucketAccessMonitorResult.Builder)((PutBucketAccessMonitorResult.Builder)((PutBucketAccessMonitorResult.Builder)PutBucketAccessMonitorResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromGetBucketAccessMonitor(GetBucketAccessMonitorRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("GetBucketAccessMonitor").method("GET");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("accessmonitor", "");
        builder.parameters(parameters);
        builder.bucket(request.bucket());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static GetBucketAccessMonitorResult toGetBucketAccessMonitor(OperationOutput output) {
        Object innerBody = null;
        innerBody = SerdeUtils.deserializeXmlBody(output, AccessMonitorConfiguration.class);
        return ((GetBucketAccessMonitorResult.Builder)((GetBucketAccessMonitorResult.Builder)((GetBucketAccessMonitorResult.Builder)((GetBucketAccessMonitorResult.Builder)GetBucketAccessMonitorResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }
}

