/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transform;

import com.aliyun.sdk.service.oss2.AttributeKey;
import com.aliyun.sdk.service.oss2.AttributeMap;
import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.models.CORSConfiguration;
import com.aliyun.sdk.service.oss2.models.DeleteBucketCorsRequest;
import com.aliyun.sdk.service.oss2.models.DeleteBucketCorsResult;
import com.aliyun.sdk.service.oss2.models.GetBucketCorsRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketCorsResult;
import com.aliyun.sdk.service.oss2.models.OptionObjectRequest;
import com.aliyun.sdk.service.oss2.models.OptionObjectResult;
import com.aliyun.sdk.service.oss2.models.PutBucketCorsRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketCorsResult;
import com.aliyun.sdk.service.oss2.transform.SerdeUtils;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.transport.StringBinaryData;
import com.aliyun.sdk.service.oss2.utils.MapUtils;
import java.util.Collections;
import java.util.Map;

public final class SerdeBucketCors {
    public static OperationInput fromPutBucketCors(PutBucketCorsRequest request) {
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/json");
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("cors", "");
        BinaryData body = null;
        body = SerdeUtils.serializeXmlBody(request.corsConfiguration());
        AttributeMap opMetadata = AttributeMap.empty();
        opMetadata.put(AttributeKey.SUBRESOURCE, Collections.singletonList("cors"));
        OperationInput input = OperationInput.newBuilder().opName("PutBucketCors").bucket(request.bucket()).method("PUT").headers(headers).parameters(parameters).opMetadata(opMetadata).body(body).build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static PutBucketCorsResult toPutBucketCors(OperationOutput output) {
        return ((PutBucketCorsResult.Builder)((PutBucketCorsResult.Builder)((PutBucketCorsResult.Builder)PutBucketCorsResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).build();
    }

    public static OperationInput fromGetBucketCors(GetBucketCorsRequest request) {
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/json");
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("cors", "");
        StringBinaryData body = null;
        body = new StringBinaryData("");
        AttributeMap opMetadata = AttributeMap.empty();
        opMetadata.put(AttributeKey.SUBRESOURCE, Collections.singletonList("cors"));
        OperationInput input = OperationInput.newBuilder().opName("GetBucketCors").method("GET").headers(headers).parameters(parameters).opMetadata(opMetadata).body(body).bucket(request.bucket()).build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static GetBucketCorsResult toGetBucketCors(OperationOutput output) {
        return ((GetBucketCorsResult.Builder)((GetBucketCorsResult.Builder)((GetBucketCorsResult.Builder)((GetBucketCorsResult.Builder)GetBucketCorsResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(SerdeUtils.deserializeXmlBody(output, CORSConfiguration.class))).build();
    }

    public static OperationInput fromDeleteBucketCors(DeleteBucketCorsRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("DeleteBucketCors").method("DELETE");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("cors", "");
        builder.parameters(parameters);
        AttributeMap opMetadata = AttributeMap.empty();
        opMetadata.put(AttributeKey.SUBRESOURCE, Collections.singletonList("cors"));
        builder.opMetadata(opMetadata);
        builder.bucket(request.bucket());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static DeleteBucketCorsResult toDeleteBucketCors(OperationOutput output) {
        Object innerBody = null;
        return ((DeleteBucketCorsResult.Builder)((DeleteBucketCorsResult.Builder)((DeleteBucketCorsResult.Builder)((DeleteBucketCorsResult.Builder)DeleteBucketCorsResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromOptionObject(OptionObjectRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("OptionObject").method("OPTIONS");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static OptionObjectResult toOptionObject(OperationOutput output) {
        Object innerBody = null;
        return ((OptionObjectResult.Builder)((OptionObjectResult.Builder)((OptionObjectResult.Builder)((OptionObjectResult.Builder)OptionObjectResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }
}

