/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transform;

import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.models.DeleteBucketEncryptionRequest;
import com.aliyun.sdk.service.oss2.models.DeleteBucketEncryptionResult;
import com.aliyun.sdk.service.oss2.models.GetBucketEncryptionRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketEncryptionResult;
import com.aliyun.sdk.service.oss2.models.PutBucketEncryptionRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketEncryptionResult;
import com.aliyun.sdk.service.oss2.models.ServerSideEncryptionRule;
import com.aliyun.sdk.service.oss2.transform.SerdeUtils;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.utils.MapUtils;
import java.util.Map;

public final class SerdeBucketEncryption {
    public static OperationInput fromPutBucketEncryption(PutBucketEncryptionRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("PutBucketEncryption").method("PUT");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("encryption", "");
        builder.parameters(parameters);
        BinaryData body = SerdeUtils.serializeXmlBody(request.serverSideEncryptionRule());
        builder.body(body);
        builder.bucket(request.bucket());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static PutBucketEncryptionResult toPutBucketEncryption(OperationOutput output) {
        Object innerBody = null;
        return ((PutBucketEncryptionResult.Builder)((PutBucketEncryptionResult.Builder)((PutBucketEncryptionResult.Builder)((PutBucketEncryptionResult.Builder)PutBucketEncryptionResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromGetBucketEncryption(GetBucketEncryptionRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("GetBucketEncryption").method("GET");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("encryption", "");
        builder.parameters(parameters);
        builder.bucket(request.bucket());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static GetBucketEncryptionResult toGetBucketEncryption(OperationOutput output) {
        Object innerBody = null;
        innerBody = SerdeUtils.deserializeXmlBody(output, ServerSideEncryptionRule.class);
        return ((GetBucketEncryptionResult.Builder)((GetBucketEncryptionResult.Builder)((GetBucketEncryptionResult.Builder)((GetBucketEncryptionResult.Builder)GetBucketEncryptionResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromDeleteBucketEncryption(DeleteBucketEncryptionRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("DeleteBucketEncryption").method("DELETE");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("encryption", "");
        builder.parameters(parameters);
        builder.bucket(request.bucket());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static DeleteBucketEncryptionResult toDeleteBucketEncryption(OperationOutput output) {
        Object innerBody = null;
        return ((DeleteBucketEncryptionResult.Builder)((DeleteBucketEncryptionResult.Builder)((DeleteBucketEncryptionResult.Builder)((DeleteBucketEncryptionResult.Builder)DeleteBucketEncryptionResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }
}

