/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transform;

import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.models.GetBucketRefererRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketRefererResult;
import com.aliyun.sdk.service.oss2.models.PutBucketRefererRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketRefererResult;
import com.aliyun.sdk.service.oss2.models.RefererConfiguration;
import com.aliyun.sdk.service.oss2.transform.SerdeUtils;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.utils.MapUtils;
import java.util.Map;

public final class SerdeBucketReferer {
    public static OperationInput fromPutBucketReferer(PutBucketRefererRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("PutBucketReferer").method("PUT");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("referer", "");
        builder.parameters(parameters);
        BinaryData body = SerdeUtils.serializeXmlBody(request.refererConfiguration());
        builder.body(body);
        builder.bucket(request.bucket());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static PutBucketRefererResult toPutBucketReferer(OperationOutput output) {
        Object innerBody = null;
        return ((PutBucketRefererResult.Builder)((PutBucketRefererResult.Builder)((PutBucketRefererResult.Builder)((PutBucketRefererResult.Builder)PutBucketRefererResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromGetBucketReferer(GetBucketRefererRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("GetBucketReferer").method("GET");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("referer", "");
        builder.parameters(parameters);
        builder.bucket(request.bucket());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static GetBucketRefererResult toGetBucketReferer(OperationOutput output) {
        Object innerBody = null;
        innerBody = SerdeUtils.deserializeXmlBody(output, RefererConfiguration.class);
        return ((GetBucketRefererResult.Builder)((GetBucketRefererResult.Builder)((GetBucketRefererResult.Builder)((GetBucketRefererResult.Builder)GetBucketRefererResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }
}

