/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transform;

import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.models.DeleteBucketTagsRequest;
import com.aliyun.sdk.service.oss2.models.DeleteBucketTagsResult;
import com.aliyun.sdk.service.oss2.models.GetBucketTagsRequest;
import com.aliyun.sdk.service.oss2.models.GetBucketTagsResult;
import com.aliyun.sdk.service.oss2.models.PutBucketTagsRequest;
import com.aliyun.sdk.service.oss2.models.PutBucketTagsResult;
import com.aliyun.sdk.service.oss2.models.Tagging;
import com.aliyun.sdk.service.oss2.transform.SerdeUtils;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.utils.MapUtils;
import java.util.Map;

public final class SerdeBucketTags {
    public static OperationInput fromPutBucketTags(PutBucketTagsRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("PutBucketTags").method("PUT");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("tagging", "");
        builder.parameters(parameters);
        BinaryData body = SerdeUtils.serializeXmlBody(request.tagging());
        builder.body(body);
        builder.bucket(request.bucket());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static PutBucketTagsResult toPutBucketTags(OperationOutput output) {
        Object innerBody = null;
        return ((PutBucketTagsResult.Builder)((PutBucketTagsResult.Builder)((PutBucketTagsResult.Builder)((PutBucketTagsResult.Builder)PutBucketTagsResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromGetBucketTags(GetBucketTagsRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("GetBucketTags").method("GET");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("tagging", "");
        builder.parameters(parameters);
        builder.bucket(request.bucket());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static GetBucketTagsResult toGetBucketTags(OperationOutput output) {
        Object innerBody = null;
        innerBody = SerdeUtils.deserializeXmlBody(output, Tagging.class);
        return ((GetBucketTagsResult.Builder)((GetBucketTagsResult.Builder)((GetBucketTagsResult.Builder)((GetBucketTagsResult.Builder)GetBucketTagsResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromDeleteBucketTags(DeleteBucketTagsRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("DeleteBucketTags").method("DELETE");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("tagging", "");
        builder.parameters(parameters);
        builder.bucket(request.bucket());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static DeleteBucketTagsResult toDeleteBucketTags(OperationOutput output) {
        Object innerBody = null;
        return ((DeleteBucketTagsResult.Builder)((DeleteBucketTagsResult.Builder)((DeleteBucketTagsResult.Builder)((DeleteBucketTagsResult.Builder)DeleteBucketTagsResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }
}

