/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transform;

import com.aliyun.sdk.service.oss2.AttributeKey;
import com.aliyun.sdk.service.oss2.AttributeMap;
import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.hash.CRC64Observer;
import com.aliyun.sdk.service.oss2.hash.CRC64ResponseChecker;
import com.aliyun.sdk.service.oss2.io.StreamObserver;
import com.aliyun.sdk.service.oss2.models.AppendObjectRequest;
import com.aliyun.sdk.service.oss2.models.AppendObjectResult;
import com.aliyun.sdk.service.oss2.models.CleanRestoredObjectRequest;
import com.aliyun.sdk.service.oss2.models.CleanRestoredObjectResult;
import com.aliyun.sdk.service.oss2.models.CopyObjectRequest;
import com.aliyun.sdk.service.oss2.models.CopyObjectResult;
import com.aliyun.sdk.service.oss2.models.DeleteMultipleObjectsRequest;
import com.aliyun.sdk.service.oss2.models.DeleteMultipleObjectsResult;
import com.aliyun.sdk.service.oss2.models.DeleteObject;
import com.aliyun.sdk.service.oss2.models.DeleteObjectRequest;
import com.aliyun.sdk.service.oss2.models.DeleteObjectResult;
import com.aliyun.sdk.service.oss2.models.GetObjectMetaRequest;
import com.aliyun.sdk.service.oss2.models.GetObjectMetaResult;
import com.aliyun.sdk.service.oss2.models.GetObjectRequest;
import com.aliyun.sdk.service.oss2.models.GetObjectResult;
import com.aliyun.sdk.service.oss2.models.HeadObjectRequest;
import com.aliyun.sdk.service.oss2.models.HeadObjectResult;
import com.aliyun.sdk.service.oss2.models.ObjectIdentifier;
import com.aliyun.sdk.service.oss2.models.PutObjectRequest;
import com.aliyun.sdk.service.oss2.models.PutObjectResult;
import com.aliyun.sdk.service.oss2.models.RestoreObjectRequest;
import com.aliyun.sdk.service.oss2.models.RestoreObjectResult;
import com.aliyun.sdk.service.oss2.models.SealAppendObjectRequest;
import com.aliyun.sdk.service.oss2.models.SealAppendObjectResult;
import com.aliyun.sdk.service.oss2.models.internal.DeleteResultXml;
import com.aliyun.sdk.service.oss2.progress.ProgressObserver;
import com.aliyun.sdk.service.oss2.transform.SerdeUtils;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.transport.InputStreamBinaryData;
import com.aliyun.sdk.service.oss2.types.FeatureFlagsType;
import com.aliyun.sdk.service.oss2.utils.HttpUtils;
import com.aliyun.sdk.service.oss2.utils.MapUtils;
import com.aliyun.sdk.service.oss2.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class SerdeObjectBasic {
    public static OperationInput fromPutObject(PutObjectRequest request, int featureFlags) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("PutObject").method("PUT");
        if (request.body() != null) {
            builder.body(request.body());
        }
        AttributeMap opMetadata = AttributeMap.empty();
        ArrayList<StreamObserver> streamObservers = new ArrayList<StreamObserver>();
        ArrayList<CRC64ResponseChecker> responseHandlers = new ArrayList<CRC64ResponseChecker>();
        if (request.progressListener() != null) {
            streamObservers.add(new ProgressObserver(request.progressListener(), request.body().getLength()));
        }
        if (FeatureFlagsType.ENABLE_CRC64_CHECK_UPLOAD.isSet(featureFlags)) {
            CRC64Observer observer = new CRC64Observer();
            streamObservers.add(observer);
            responseHandlers.add(new CRC64ResponseChecker(observer.getChecksum()));
        }
        if (!streamObservers.isEmpty()) {
            opMetadata.put(AttributeKey.UPLOAD_OBSERVER, streamObservers);
        }
        if (!responseHandlers.isEmpty()) {
            opMetadata.put(AttributeKey.RESPONSE_HANDLER, responseHandlers);
        }
        builder.opMetadata(opMetadata);
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, new BiConsumer[0]);
        if (FeatureFlagsType.AUTO_DETECT_MIMETYPE.isSet(featureFlags)) {
            SerdeUtils.addContentType(input);
        }
        return input;
    }

    public static PutObjectResult toPutObject(OperationOutput output) {
        String bodyStr = null;
        if (output.body().isPresent()) {
            bodyStr = output.body().get().toString();
        }
        return ((PutObjectResult.Builder)((PutObjectResult.Builder)((PutObjectResult.Builder)((PutObjectResult.Builder)PutObjectResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(bodyStr)).build();
    }

    public static OperationInput fromCopyObject(CopyObjectRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("CopyObject").method("PUT");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("x-oss-copy-source", SerdeUtils.encodeCopySource(request));
        builder.headers(headers);
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static CopyObjectResult toCopyObject(OperationOutput output) {
        Object innerBody = null;
        innerBody = SerdeUtils.deserializeXmlBody(output, String.class);
        return ((CopyObjectResult.Builder)((CopyObjectResult.Builder)((CopyObjectResult.Builder)((CopyObjectResult.Builder)CopyObjectResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromGetObject(GetObjectRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("GetObject").method("GET");
        builder.bucket(request.bucket());
        builder.key(request.key());
        if (request.dataConsumerSupplier() != null) {
            AttributeMap opMetadata = AttributeMap.empty();
            opMetadata.put(AttributeKey.RESPONSE_CONSUMER_SUPPLIER, request.dataConsumerSupplier());
            builder.opMetadata(opMetadata);
        }
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, new BiConsumer[0]);
        return input;
    }

    public static GetObjectResult toGetObject(OperationOutput output) {
        BinaryData body = output.body().orElse(null);
        InputStream is = body instanceof InputStreamBinaryData ? ((InputStreamBinaryData)body).unwrap() : (body != null ? body.toStream() : new ByteArrayInputStream(new byte[0]));
        return ((GetObjectResult.Builder)((GetObjectResult.Builder)((GetObjectResult.Builder)((GetObjectResult.Builder)GetObjectResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(is)).build();
    }

    public static OperationInput fromAppendObject(AppendObjectRequest request, int featureFlags) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("AppendObject").method("POST");
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("append", "");
        builder.parameters(parameters);
        builder.body(request.body());
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, new BiConsumer[0]);
        if (FeatureFlagsType.AUTO_DETECT_MIMETYPE.isSet(featureFlags)) {
            SerdeUtils.addContentType(input);
        }
        return input;
    }

    public static AppendObjectResult toAppendObject(OperationOutput output) {
        Object innerBody = null;
        return ((AppendObjectResult.Builder)((AppendObjectResult.Builder)((AppendObjectResult.Builder)((AppendObjectResult.Builder)AppendObjectResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromDeleteObject(DeleteObjectRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("DeleteObject").method("DELETE");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static DeleteObjectResult toDeleteObject(OperationOutput output) {
        Object innerBody = null;
        return ((DeleteObjectResult.Builder)((DeleteObjectResult.Builder)((DeleteObjectResult.Builder)((DeleteObjectResult.Builder)DeleteObjectResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromDeleteMultipleObjects(DeleteMultipleObjectsRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("DeleteMultipleObjects").method("POST");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("delete", "");
        parameters.put("encoding-type", "url");
        builder.parameters(parameters);
        if (request.deleteObjects() != null && request.delete() != null) {
            throw new IllegalArgumentException("Either old parameters (objects, quiet) or new parameter (delete) is set, but not both");
        }
        StringBuilder xmlBody = new StringBuilder();
        xmlBody.append("<Delete>");
        if (request.delete() != null) {
            if (request.delete().quiet() != null) {
                xmlBody.append("<Quiet>").append(request.delete().quiet()).append("</Quiet>");
            }
            if (request.delete().objects() != null) {
                for (ObjectIdentifier objectIdentifier : request.delete().objects()) {
                    xmlBody.append("<Object>");
                    xmlBody.append("<Key>").append(XmlUtils.escapeText(objectIdentifier.key())).append("</Key>");
                    if (objectIdentifier.versionId() != null) {
                        xmlBody.append("<VersionId>").append(XmlUtils.escapeText(objectIdentifier.versionId())).append("</VersionId>");
                    }
                    xmlBody.append("</Object>");
                }
            }
        } else {
            if (request.quiet() != null) {
                xmlBody.append("<Quiet>").append(request.quiet()).append("</Quiet>");
            }
            if (request.deleteObjects() != null) {
                for (DeleteObject deleteObject : request.deleteObjects()) {
                    xmlBody.append("<Object>");
                    xmlBody.append("<Key>").append(XmlUtils.escapeText(deleteObject.key())).append("</Key>");
                    if (deleteObject.versionId() != null) {
                        xmlBody.append("<VersionId>").append(XmlUtils.escapeText(deleteObject.versionId())).append("</VersionId>");
                    }
                    xmlBody.append("</Object>");
                }
            }
        }
        xmlBody.append("</Delete>");
        String xmlStr = xmlBody.toString();
        builder.body(BinaryData.fromBytes(xmlStr.getBytes(StandardCharsets.UTF_8)));
        builder.bucket(request.bucket());
        OperationInput operationInput = builder.build();
        SerdeUtils.serializeInput(request, operationInput, SerdeUtils.addContentMd5);
        return operationInput;
    }

    public static DeleteMultipleObjectsResult toDeleteMultipleObjects(OperationOutput output) {
        DeleteResultXml innerBody = (DeleteResultXml)SerdeUtils.deserializeXmlBody(output, DeleteResultXml.class);
        if (innerBody == null) {
            innerBody = new DeleteResultXml();
        }
        if ("url".equals(innerBody.encodingType) && innerBody.deleted != null) {
            innerBody.deleted = innerBody.deleted.stream().map(x -> x.toBuilder().key(HttpUtils.urlDecode(x.key())).build()).collect(Collectors.toList());
        }
        return ((DeleteMultipleObjectsResult.Builder)((DeleteMultipleObjectsResult.Builder)((DeleteMultipleObjectsResult.Builder)((DeleteMultipleObjectsResult.Builder)DeleteMultipleObjectsResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromHeadObject(HeadObjectRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("HeadObject").method("HEAD");
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static HeadObjectResult toHeadObject(OperationOutput output) {
        Object innerBody = null;
        return ((HeadObjectResult.Builder)((HeadObjectResult.Builder)((HeadObjectResult.Builder)((HeadObjectResult.Builder)HeadObjectResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromGetObjectMeta(GetObjectMetaRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("GetObjectMeta").method("HEAD");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("objectMeta", "");
        builder.parameters(parameters);
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static GetObjectMetaResult toGetObjectMeta(OperationOutput output) {
        Object innerBody = null;
        return ((GetObjectMetaResult.Builder)((GetObjectMetaResult.Builder)((GetObjectMetaResult.Builder)((GetObjectMetaResult.Builder)GetObjectMetaResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromRestoreObject(RestoreObjectRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("RestoreObject").method("POST");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("restore", "");
        builder.parameters(parameters);
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static RestoreObjectResult toRestoreObject(OperationOutput output) {
        Object innerBody = null;
        return ((RestoreObjectResult.Builder)((RestoreObjectResult.Builder)((RestoreObjectResult.Builder)((RestoreObjectResult.Builder)RestoreObjectResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromCleanRestoredObject(CleanRestoredObjectRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("CleanRestoredObject").method("POST");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("cleanRestoredObject", "");
        builder.parameters(parameters);
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static CleanRestoredObjectResult toCleanRestoredObject(OperationOutput output) {
        Object innerBody = null;
        return ((CleanRestoredObjectResult.Builder)((CleanRestoredObjectResult.Builder)((CleanRestoredObjectResult.Builder)((CleanRestoredObjectResult.Builder)CleanRestoredObjectResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }

    public static OperationInput fromSealAppendObject(SealAppendObjectRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("SealAppendObject").method("POST");
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("seal", "");
        if (request.position() != null) {
            parameters.put("position", request.position());
        }
        builder.parameters(parameters);
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, new BiConsumer[0]);
        return input;
    }

    public static SealAppendObjectResult toSealAppendObject(OperationOutput output) {
        Object innerBody = null;
        return ((SealAppendObjectResult.Builder)((SealAppendObjectResult.Builder)((SealAppendObjectResult.Builder)((SealAppendObjectResult.Builder)SealAppendObjectResult.newBuilder().headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(innerBody)).build();
    }
}

