/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transform;

import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.models.AsyncProcessObjectRequest;
import com.aliyun.sdk.service.oss2.models.AsyncProcessObjectResult;
import com.aliyun.sdk.service.oss2.models.ProcessObjectRequest;
import com.aliyun.sdk.service.oss2.models.ProcessObjectResult;
import com.aliyun.sdk.service.oss2.models.internal.AsyncProcessJson;
import com.aliyun.sdk.service.oss2.models.internal.ImageProcessJson;
import com.aliyun.sdk.service.oss2.transform.SerdeUtils;
import com.aliyun.sdk.service.oss2.transport.StringBinaryData;
import com.aliyun.sdk.service.oss2.utils.MapUtils;
import java.util.Map;

public class SerdeProcessObject {
    public static OperationInput fromProcessObject(ProcessObjectRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("ProcessObject").method("POST");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("x-oss-process", "");
        builder.parameters(parameters);
        String processParam = "x-oss-process=" + request.process();
        StringBinaryData body = new StringBinaryData(processParam);
        builder.body(body);
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static ProcessObjectResult toProcessObject(OperationOutput output) {
        ProcessObjectResult.Builder builder = ProcessObjectResult.newBuilder();
        ImageProcessJson imageProcess = SerdeUtils.fromJsonBody(output, ImageProcessJson.class);
        return ((ProcessObjectResult.Builder)((ProcessObjectResult.Builder)((ProcessObjectResult.Builder)((ProcessObjectResult.Builder)builder.headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(imageProcess)).build();
    }

    public static OperationInput fromAsyncProcessObject(AsyncProcessObjectRequest request) {
        OperationInput.Builder builder = OperationInput.newBuilder().opName("AsyncProcessObject").method("POST");
        Map<String, String> headers = MapUtils.caseInsensitiveMap();
        headers.put("Content-Type", "application/xml");
        builder.headers(headers);
        Map<String, String> parameters = MapUtils.caseSensitiveMap();
        parameters.put("x-oss-async-process", "");
        builder.parameters(parameters);
        String processParam = "x-oss-async-process=" + request.process();
        StringBinaryData body = new StringBinaryData(processParam);
        builder.body(body);
        builder.bucket(request.bucket());
        builder.key(request.key());
        OperationInput input = builder.build();
        SerdeUtils.serializeInput(request, input, SerdeUtils.addContentMd5);
        return input;
    }

    public static AsyncProcessObjectResult toAsyncProcessObject(OperationOutput output) {
        AsyncProcessObjectResult.Builder builder = AsyncProcessObjectResult.newBuilder();
        AsyncProcessJson asyncProcess = SerdeUtils.fromJsonBody(output, AsyncProcessJson.class);
        return ((AsyncProcessObjectResult.Builder)((AsyncProcessObjectResult.Builder)((AsyncProcessObjectResult.Builder)((AsyncProcessObjectResult.Builder)builder.headers(output.headers)).status(output.status)).statusCode(output.statusCode)).innerBody(asyncProcess)).build();
    }
}

