/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transform;

import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.exceptions.DeserializationException;
import com.aliyun.sdk.service.oss2.models.CopyObjectRequest;
import com.aliyun.sdk.service.oss2.models.RequestModel;
import com.aliyun.sdk.service.oss2.models.UploadPartCopyRequest;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.transport.StringBinaryData;
import com.aliyun.sdk.service.oss2.utils.HttpUtils;
import com.aliyun.sdk.service.oss2.utils.Md5Utils;
import com.aliyun.sdk.service.oss2.utils.MimeUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.StringWriter;
import java.util.function.BiConsumer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public final class SerdeUtils {
    public static BiConsumer<RequestModel, OperationInput> addContentMd5 = new CalcContentMd5();

    @SafeVarargs
    public static void serializeInput(RequestModel request, OperationInput input, BiConsumer<RequestModel, OperationInput> ... consumers) {
        if (request.headers() != null) {
            input.headers().putAll(request.headers());
        }
        if (request.parameters() != null) {
            input.parameters().putAll(request.parameters());
        }
        for (BiConsumer<RequestModel, OperationInput> consumer : consumers) {
            consumer.accept(request, input);
        }
    }

    public static BinaryData serializeXmlBody(Object value) {
        if (value == null) {
            return null;
        }
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return new StringBinaryData(xmlMapper.writeValueAsString(value));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Object deserializeXmlBody(OperationOutput output, Class<T> clz) {
        byte[] xmlBytes;
        if (!output.body().isPresent()) {
            return null;
        }
        try {
            xmlBytes = output.body().get().toBytes();
        }
        catch (Exception e) {
            throw new DeserializationException("Failed to read content", e);
        }
        if (xmlBytes == null || xmlBytes.length == 0) {
            return null;
        }
        try {
            XmlMapper xmlMapper = new XmlMapper();
            xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            xmlMapper.registerModule((Module)new JavaTimeModule());
            xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return xmlMapper.readValue(xmlBytes, clz);
        }
        catch (Exception e) {
            throw new DeserializationException("Failed to parse XML", e);
        }
    }

    static String elementToString(Element element) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(element), new StreamResult(writer));
        return writer.toString();
    }

    public static String encodeCopySource(Object request) {
        String sourceBucket = null;
        String bucket = null;
        String sourceKey = null;
        String sourceVersionId = null;
        if (request instanceof CopyObjectRequest) {
            CopyObjectRequest copyRequest = (CopyObjectRequest)request;
            sourceBucket = copyRequest.sourceBucket();
            bucket = copyRequest.bucket();
            sourceKey = copyRequest.sourceKey();
            sourceVersionId = copyRequest.sourceVersionId();
        } else if (request instanceof UploadPartCopyRequest) {
            UploadPartCopyRequest uploadRequest = (UploadPartCopyRequest)request;
            sourceBucket = uploadRequest.sourceBucket();
            bucket = uploadRequest.bucket();
            sourceKey = uploadRequest.sourceKey();
            sourceVersionId = uploadRequest.sourceVersionId();
        }
        String bucketName = sourceBucket != null && !sourceBucket.isEmpty() ? sourceBucket : bucket;
        String encodedSource = "/" + bucketName + "/" + HttpUtils.urlEncode(sourceKey);
        if (sourceVersionId != null && !sourceVersionId.isEmpty()) {
            encodedSource = encodedSource + "?versionId=" + sourceVersionId;
        }
        return encodedSource;
    }

    static void addContentType(OperationInput input) {
        if (input.headers().containsKey("Content-Type")) {
            return;
        }
        String value = MimeUtils.getMimetype(input.key().orElse(null), "application/octet-stream");
        input.headers().put("Content-Type", value);
    }

    public static <T> T fromJsonBody(OperationOutput output, Class<T> clazz) {
        byte[] jsonBytes;
        if (!output.body().isPresent()) {
            return null;
        }
        try {
            jsonBytes = output.body().get().toBytes();
        }
        catch (Exception e) {
            throw new DeserializationException("Failed to read content", e);
        }
        if (jsonBytes == null || jsonBytes.length == 0) {
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.registerModule((Module)new JavaTimeModule());
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T)objectMapper.readValue(jsonBytes, clazz);
        }
        catch (Exception e) {
            throw new DeserializationException("Failed to parse JSON", e);
        }
    }

    static class CalcContentMd5
    implements BiConsumer<RequestModel, OperationInput> {
        CalcContentMd5() {
        }

        @Override
        public void accept(RequestModel request, OperationInput input) {
            if (input.headers().containsKey("Content-MD5")) {
                return;
            }
            String md5 = "1B2M2Y8AsgTpgAmY7PhCfg==";
            if (input.body().isPresent()) {
                byte[] data = input.body().get().toBytes();
                md5 = Md5Utils.md5AsBase64(data);
            }
            input.headers().put("Content-MD5", md5);
        }
    }
}

